/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.wlm;

import org.graylog.shaded.opensearch2.org.opensearch.tasks.Task;
import org.graylog.shaded.opensearch2.org.opensearch.threadpool.ThreadPool;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportChannel;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportInterceptor;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequest;
import org.graylog.shaded.opensearch2.org.opensearch.transport.TransportRequestHandler;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupService;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupTask;

public class WorkloadManagementTransportInterceptor
implements TransportInterceptor {
    private final ThreadPool threadPool;
    private final QueryGroupService queryGroupService;

    public WorkloadManagementTransportInterceptor(ThreadPool threadPool, QueryGroupService queryGroupService) {
        this.threadPool = threadPool;
        this.queryGroupService = queryGroupService;
    }

    @Override
    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new RequestHandler<T>(this.threadPool, actualHandler, this.queryGroupService);
    }

    public static class RequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final ThreadPool threadPool;
        TransportRequestHandler<T> actualHandler;
        private final QueryGroupService queryGroupService;

        public RequestHandler(ThreadPool threadPool, TransportRequestHandler<T> actualHandler, QueryGroupService queryGroupService) {
            this.threadPool = threadPool;
            this.actualHandler = actualHandler;
            this.queryGroupService = queryGroupService;
        }

        @Override
        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
            if (this.isSearchWorkloadRequest(task)) {
                ((QueryGroupTask)task).setQueryGroupId(this.threadPool.getThreadContext());
                String queryGroupId = ((QueryGroupTask)task).getQueryGroupId();
                this.queryGroupService.rejectIfNeeded(queryGroupId);
            }
            this.actualHandler.messageReceived(request, channel, task);
        }

        boolean isSearchWorkloadRequest(Task task) {
            return task instanceof QueryGroupTask;
        }
    }
}

