/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.wlm.cancellation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.QueryGroup;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.CancellableTask;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskCancellation;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.MutableQueryGroupFragment;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupLevelResourceUsageView;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupTask;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupsStateAccessor;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.ResourceType;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.WlmMode;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.WorkloadManagementSettings;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.cancellation.TaskSelectionStrategy;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.stats.QueryGroupState;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker.QueryGroupResourceUsageTrackerService;

public class QueryGroupTaskCancellationService {
    public static final double MIN_VALUE = 1.0E-9;
    private static final Logger log = LogManager.getLogger(QueryGroupTaskCancellationService.class);
    private final WorkloadManagementSettings workloadManagementSettings;
    private final TaskSelectionStrategy taskSelectionStrategy;
    private final QueryGroupResourceUsageTrackerService resourceUsageTrackerService;
    Map<String, QueryGroupLevelResourceUsageView> queryGroupLevelResourceUsageViews;
    private final QueryGroupsStateAccessor queryGroupStateAccessor;

    public QueryGroupTaskCancellationService(WorkloadManagementSettings workloadManagementSettings, TaskSelectionStrategy taskSelectionStrategy, QueryGroupResourceUsageTrackerService resourceUsageTrackerService, QueryGroupsStateAccessor queryGroupStateAccessor) {
        this.workloadManagementSettings = workloadManagementSettings;
        this.taskSelectionStrategy = taskSelectionStrategy;
        this.resourceUsageTrackerService = resourceUsageTrackerService;
        this.queryGroupStateAccessor = queryGroupStateAccessor;
    }

    public void cancelTasks(BooleanSupplier isNodeInDuress, Collection<QueryGroup> activeQueryGroups, Collection<QueryGroup> deletedQueryGroups) {
        this.queryGroupLevelResourceUsageViews = this.resourceUsageTrackerService.constructQueryGroupLevelUsageViews();
        this.cancelTasks(MutableQueryGroupFragment.ResiliencyMode.ENFORCED, activeQueryGroups);
        this.handleNodeDuress(isNodeInDuress, activeQueryGroups, deletedQueryGroups);
        this.updateResourceUsageInQueryGroupState(activeQueryGroups);
    }

    private void updateResourceUsageInQueryGroupState(Collection<QueryGroup> activeQueryGroups) {
        HashSet<String> isSearchWorkloadRunning = new HashSet<String>();
        for (Map.Entry<String, QueryGroupLevelResourceUsageView> queryGroupLevelResourceUsageViewEntry : this.queryGroupLevelResourceUsageViews.entrySet()) {
            isSearchWorkloadRunning.add(queryGroupLevelResourceUsageViewEntry.getKey());
            QueryGroupState queryGroupState = this.getQueryGroupState(queryGroupLevelResourceUsageViewEntry.getKey());
            QueryGroupResourceUsageTrackerService.TRACKED_RESOURCES.forEach(resourceType -> {
                double currentUsage = ((QueryGroupLevelResourceUsageView)queryGroupLevelResourceUsageViewEntry.getValue()).getResourceUsageData().get(resourceType);
                queryGroupState.getResourceState().get(resourceType).setLastRecordedUsage(currentUsage);
            });
        }
        activeQueryGroups.forEach(queryGroup -> {
            if (!isSearchWorkloadRunning.contains(queryGroup.get_id())) {
                QueryGroupResourceUsageTrackerService.TRACKED_RESOURCES.forEach(resourceType -> this.getQueryGroupState(queryGroup.get_id()).getResourceState().get(resourceType).setLastRecordedUsage(0.0));
            }
        });
    }

    private void handleNodeDuress(BooleanSupplier isNodeInDuress, Collection<QueryGroup> activeQueryGroups, Collection<QueryGroup> deletedQueryGroups) {
        if (!isNodeInDuress.getAsBoolean()) {
            return;
        }
        List<Consumer<Void>> duressActions = List.of(v -> this.cancelTasksFromDeletedQueryGroups(deletedQueryGroups), v -> this.cancelTasks(MutableQueryGroupFragment.ResiliencyMode.SOFT, activeQueryGroups));
        for (Consumer<Void> duressAction : duressActions) {
            if (!isNodeInDuress.getAsBoolean()) break;
            duressAction.accept(null);
        }
    }

    private void cancelTasksFromDeletedQueryGroups(Collection<QueryGroup> deletedQueryGroups) {
        this.cancelTasks(this.getAllCancellableTasks(deletedQueryGroups));
    }

    List<TaskCancellation> getAllCancellableTasks(MutableQueryGroupFragment.ResiliencyMode resiliencyMode, Collection<QueryGroup> queryGroups) {
        return this.getAllCancellableTasks(queryGroups.stream().filter(queryGroup -> queryGroup.getResiliencyMode() == resiliencyMode).collect(Collectors.toList()));
    }

    List<TaskCancellation> getAllCancellableTasks(Collection<QueryGroup> queryGroups) {
        ArrayList<TaskCancellation> taskCancellations = new ArrayList<TaskCancellation>();
        ArrayList<Runnable> onCancelCallbacks = new ArrayList<Runnable>();
        for (QueryGroup queryGroup : queryGroups) {
            ArrayList<TaskCancellation.Reason> reasons = new ArrayList<TaskCancellation.Reason>();
            ArrayList<QueryGroupTask> selectedTasks = new ArrayList<QueryGroupTask>();
            for (ResourceType resourceType : QueryGroupResourceUsageTrackerService.TRACKED_RESOURCES) {
                double excessUsage = this.getExcessUsage(queryGroup, resourceType) - resourceType.getResourceUsageCalculator().calculateResourceUsage(selectedTasks);
                if (!(excessUsage > 1.0E-9)) continue;
                reasons.add(new TaskCancellation.Reason(this.generateReasonString(queryGroup, resourceType), 1));
                onCancelCallbacks.add(this.getResourceTypeOnCancelCallback(queryGroup.get_id(), resourceType));
                selectedTasks.addAll(this.taskSelectionStrategy.selectTasksForCancellation(this.getTasksFor(queryGroup), excessUsage, resourceType).stream().filter(x -> selectedTasks.stream().noneMatch(y -> x.getId() != y.getId())).collect(Collectors.toList()));
            }
            if (reasons.isEmpty()) continue;
            onCancelCallbacks.add(this.getQueryGroupState((String)queryGroup.get_id()).totalCancellations::inc);
            taskCancellations.addAll(selectedTasks.stream().map(task -> new TaskCancellation((CancellableTask)task, (List<TaskCancellation.Reason>)reasons, (List<Runnable>)onCancelCallbacks)).collect(Collectors.toList()));
        }
        return taskCancellations;
    }

    private String generateReasonString(QueryGroup queryGroup, ResourceType resourceType) {
        double currentUsage = this.getCurrentUsage(queryGroup, resourceType);
        return "QueryGroup ID : " + queryGroup.get_id() + " breached the resource limit: (" + currentUsage + " > " + String.valueOf(queryGroup.getResourceLimits().get((Object)resourceType)) + ") for resource type : " + resourceType.getName();
    }

    private List<QueryGroupTask> getTasksFor(QueryGroup queryGroup) {
        return this.queryGroupLevelResourceUsageViews.get(queryGroup.get_id()).getActiveTasks();
    }

    private void cancelTasks(MutableQueryGroupFragment.ResiliencyMode resiliencyMode, Collection<QueryGroup> queryGroups) {
        this.cancelTasks(this.getAllCancellableTasks(resiliencyMode, queryGroups));
    }

    private void cancelTasks(List<TaskCancellation> cancellableTasks) {
        Consumer<TaskCancellation> cancellationLoggingConsumer;
        Consumer<TaskCancellation> cancellationConsumer = cancellationLoggingConsumer = taskCancellation -> log.warn("Task {} is eligible for cancellation for reason {}", (Object)taskCancellation.getTask().getId(), (Object)taskCancellation.getReasonString());
        if (this.workloadManagementSettings.getWlmMode() == WlmMode.ENABLED) {
            cancellationConsumer = taskCancellation -> {
                cancellationLoggingConsumer.accept((TaskCancellation)taskCancellation);
                taskCancellation.cancel();
            };
        }
        cancellableTasks.forEach(cancellationConsumer);
    }

    private double getExcessUsage(QueryGroup queryGroup, ResourceType resourceType) {
        if (queryGroup.getResourceLimits().get((Object)resourceType) == null || !this.queryGroupLevelResourceUsageViews.containsKey(queryGroup.get_id())) {
            return 0.0;
        }
        return this.getCurrentUsage(queryGroup, resourceType) - this.getNormalisedThreshold(queryGroup, resourceType);
    }

    private double getCurrentUsage(QueryGroup queryGroup, ResourceType resourceType) {
        QueryGroupLevelResourceUsageView queryGroupResourceUsageView = this.queryGroupLevelResourceUsageViews.get(queryGroup.get_id());
        return queryGroupResourceUsageView.getResourceUsageData().get((Object)resourceType);
    }

    private double getNormalisedThreshold(QueryGroup queryGroup, ResourceType resourceType) {
        double nodeLevelCancellationThreshold = resourceType.getNodeLevelThreshold(this.workloadManagementSettings);
        return queryGroup.getResourceLimits().get((Object)resourceType) * nodeLevelCancellationThreshold;
    }

    private Runnable getResourceTypeOnCancelCallback(String queryGroupId, ResourceType resourceType) {
        QueryGroupState queryGroupState = this.getQueryGroupState(queryGroupId);
        return queryGroupState.getResourceState().get((Object)((Object)resourceType)).cancellations::inc;
    }

    private QueryGroupState getQueryGroupState(String queryGroupId) {
        assert (queryGroupId != null) : "queryGroupId should never be null at this point.";
        return this.queryGroupStateAccessor.getQueryGroupState(queryGroupId);
    }

    public void pruneDeletedQueryGroups(Collection<QueryGroup> deletedQueryGroups) {
        ArrayList<QueryGroup> currentDeletedQueryGroups = new ArrayList<QueryGroup>(deletedQueryGroups);
        for (QueryGroup queryGroup : currentDeletedQueryGroups) {
            if (!this.queryGroupLevelResourceUsageViews.get(queryGroup.get_id()).getActiveTasks().isEmpty()) continue;
            deletedQueryGroups.remove(queryGroup);
        }
    }
}

