/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.wlm.stats;

import java.util.EnumMap;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.common.metrics.CounterMetric;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.ResourceType;

public class QueryGroupState {
    public final CounterMetric totalCompletions = new CounterMetric();
    public final CounterMetric totalRejections = new CounterMetric();
    public final CounterMetric failures = new CounterMetric();
    public final CounterMetric totalCancellations = new CounterMetric();
    private final Map<ResourceType, ResourceTypeState> resourceState = new EnumMap<ResourceType, ResourceTypeState>(ResourceType.class);

    public QueryGroupState() {
        for (ResourceType resourceType : ResourceType.values()) {
            if (!resourceType.hasStatsEnabled()) continue;
            this.resourceState.put(resourceType, new ResourceTypeState(resourceType));
        }
    }

    public long getTotalCompletions() {
        return this.totalCompletions.count();
    }

    public long getTotalRejections() {
        return this.totalRejections.count();
    }

    public long getFailures() {
        return this.failures.count();
    }

    public long getTotalCancellations() {
        return this.totalCancellations.count();
    }

    public Map<ResourceType, ResourceTypeState> getResourceState() {
        return this.resourceState;
    }

    public static class ResourceTypeState {
        public final ResourceType resourceType;
        public final CounterMetric cancellations = new CounterMetric();
        public final CounterMetric rejections = new CounterMetric();
        private double lastRecordedUsage = 0.0;

        public ResourceTypeState(ResourceType resourceType) {
            this.resourceType = resourceType;
        }

        public void setLastRecordedUsage(double recordedUsage) {
            this.lastRecordedUsage = recordedUsage;
        }

        public double getLastRecordedUsage() {
            return this.lastRecordedUsage;
        }
    }
}

