/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker;

import java.util.List;
import org.graylog.shaded.opensearch2.org.opensearch.core.tasks.resourcetracker.ResourceStats;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupTask;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker.ResourceUsageCalculator;

public class CpuUsageCalculator
extends ResourceUsageCalculator {
    public static final int PROCESSOR_COUNT = Runtime.getRuntime().availableProcessors();
    public static final CpuUsageCalculator INSTANCE = new CpuUsageCalculator();

    private CpuUsageCalculator() {
    }

    @Override
    public double calculateResourceUsage(List<QueryGroupTask> tasks) {
        double usage = tasks.stream().mapToDouble(this::calculateTaskResourceUsage).sum();
        return usage /= (double)PROCESSOR_COUNT;
    }

    @Override
    public double calculateTaskResourceUsage(QueryGroupTask task) {
        return 1.0f * (float)task.getTotalResourceUtilization(ResourceStats.CPU) / (float)task.getElapsedTime();
    }
}

