/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.org.opensearch.wlm.tracker;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.tasks.TaskResourceTrackingService;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupLevelResourceUsageView;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.QueryGroupTask;
import org.graylog.shaded.opensearch2.org.opensearch.wlm.ResourceType;

public class QueryGroupResourceUsageTrackerService {
    public static final EnumSet<ResourceType> TRACKED_RESOURCES = EnumSet.allOf(ResourceType.class);
    private final TaskResourceTrackingService taskResourceTrackingService;

    public QueryGroupResourceUsageTrackerService(TaskResourceTrackingService taskResourceTrackingService) {
        this.taskResourceTrackingService = taskResourceTrackingService;
    }

    public Map<String, QueryGroupLevelResourceUsageView> constructQueryGroupLevelUsageViews() {
        Map<String, List<QueryGroupTask>> tasksByQueryGroup = this.getTasksGroupedByQueryGroup();
        HashMap<String, QueryGroupLevelResourceUsageView> queryGroupViews = new HashMap<String, QueryGroupLevelResourceUsageView>();
        for (Map.Entry<String, List<QueryGroupTask>> queryGroupEntry : tasksByQueryGroup.entrySet()) {
            this.taskResourceTrackingService.refreshResourceStats(queryGroupEntry.getValue().toArray(new QueryGroupTask[0]));
            EnumMap<ResourceType, Double> queryGroupUsage = new EnumMap<ResourceType, Double>(ResourceType.class);
            for (ResourceType resourceType : TRACKED_RESOURCES) {
                double usage = resourceType.getResourceUsageCalculator().calculateResourceUsage(queryGroupEntry.getValue());
                queryGroupUsage.put(resourceType, usage);
            }
            queryGroupViews.put(queryGroupEntry.getKey(), new QueryGroupLevelResourceUsageView(queryGroupUsage, queryGroupEntry.getValue()));
        }
        return queryGroupViews;
    }

    private Map<String, List<QueryGroupTask>> getTasksGroupedByQueryGroup() {
        return this.taskResourceTrackingService.getResourceAwareTasks().values().stream().filter(QueryGroupTask.class::isInstance).map(QueryGroupTask.class::cast).filter(QueryGroupTask::isQueryGroupSet).collect(Collectors.groupingBy(QueryGroupTask::getQueryGroupId, Collectors.mapping(task -> task, Collectors.toList())));
    }
}

