/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.opensearch2.reactor.core.publisher;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.graylog.shaded.opensearch2.reactor.core.CoreSubscriber;
import org.graylog.shaded.opensearch2.reactor.core.Fuseable;
import org.graylog.shaded.opensearch2.reactor.core.Scannable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.Flux;
import org.graylog.shaded.opensearch2.reactor.core.publisher.FluxNameFuseable;
import org.graylog.shaded.opensearch2.reactor.core.publisher.InternalFluxOperator;
import org.graylog.shaded.opensearch2.reactor.util.annotation.Nullable;
import org.graylog.shaded.opensearch2.reactor.util.function.Tuple2;
import org.graylog.shaded.opensearch2.reactor.util.function.Tuples;

final class FluxName<T>
extends InternalFluxOperator<T, T> {
    final String name;
    final List<Tuple2<String, String>> tagsWithDuplicates;

    static <T> Flux<T> createOrAppend(Flux<T> source, String name) {
        Objects.requireNonNull(name, "name");
        if (source instanceof FluxName) {
            FluxName s = (FluxName)source;
            return new FluxName<T>(s.source, name, s.tagsWithDuplicates);
        }
        if (source instanceof FluxNameFuseable) {
            FluxNameFuseable s = (FluxNameFuseable)source;
            return new FluxNameFuseable(s.source, name, s.tagsWithDuplicates);
        }
        if (source instanceof Fuseable) {
            return new FluxNameFuseable<T>(source, name, null);
        }
        return new FluxName<T>(source, name, null);
    }

    static <T> Flux<T> createOrAppend(Flux<T> source, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Tuple2<String, String> newTag = Tuples.of(tagName, tagValue);
        if (source instanceof FluxName) {
            List<Tuple2<String, String>> tags;
            FluxName s = (FluxName)source;
            if (s.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new FluxName<T>(s.source, s.name, tags);
        }
        if (source instanceof FluxNameFuseable) {
            List<Tuple2<String, String>> tags;
            FluxNameFuseable s = (FluxNameFuseable)source;
            if (s.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new FluxNameFuseable(s.source, s.name, tags);
        }
        if (source instanceof Fuseable) {
            return new FluxNameFuseable<T>(source, null, Collections.singletonList(newTag));
        }
        return new FluxName<T>(source, null, Collections.singletonList(newTag));
    }

    FluxName(Flux<? extends T> source, @Nullable String name, @Nullable List<Tuple2<String, String>> tags) {
        super(source);
        this.name = name;
        this.tagsWithDuplicates = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key) {
        if (key == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key == Scannable.Attr.TAGS && this.tagsWithDuplicates != null) {
            return this.tagsWithDuplicates.stream();
        }
        if (key == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key);
    }
}

