/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Hex;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.openssl.PEMParser;
import org.graylog.storage.opensearch2.ConnectionCheckIndex;
import org.graylog.storage.opensearch2.ConnectionCheckResponse;

public record AggregatedConnectionResponse(Map<String, ConnectionCheckResponse> responses) {
    @Nonnull
    public List<ConnectionCheckIndex> indices() {
        return this.responses.values().stream().filter(v -> Objects.nonNull(v.indices())).flatMap(v -> v.indices().stream()).sorted(Comparator.comparing(ConnectionCheckIndex::name, Comparator.naturalOrder())).distinct().collect(Collectors.toList());
    }

    @Nullable
    public String error() {
        String errorMessage = this.responses.entrySet().stream().filter(e -> Objects.nonNull(((ConnectionCheckResponse)e.getValue()).error())).map(e -> (String)e.getKey() + ": " + ((ConnectionCheckResponse)e.getValue()).error()).collect(Collectors.joining(";"));
        if (errorMessage.isEmpty()) {
            return null;
        }
        StringBuilder errorBuilder = new StringBuilder();
        errorBuilder.append(errorMessage);
        if (!this.certificates().isEmpty()) {
            errorBuilder.append("\n").append("Unknown certificates: \n").append(this.certificates().stream().map(AggregatedConnectionResponse::decode).map(this::info).collect(Collectors.joining("\n\n")));
        }
        return errorBuilder.toString();
    }

    private String info(X509Certificate certificate) {
        return "Issued to: %s,\nIssued by: %s,\nSerial number: %s,\nIssued on: %s,\nExpires on: %s,\nSHA-256 fingerprint: %s,\nSHA-1 Fingerprint: %s\n".formatted(certificate.getSubjectX500Principal().getName(), certificate.getIssuerX500Principal().getName(), certificate.getSerialNumber(), certificate.getNotBefore(), certificate.getNotAfter(), AggregatedConnectionResponse.getfingerprint(certificate, "SHA-256"), AggregatedConnectionResponse.getfingerprint(certificate, "SHA-1"));
    }

    @Nonnull
    public List<String> certificates() {
        return this.responses.values().stream().filter(v -> Objects.nonNull(v.certificates())).flatMap(v -> v.certificates().stream()).distinct().collect(Collectors.toList());
    }

    private static X509Certificate decode(String pemEncodedCert) {
        PEMParser pemParser = new PEMParser((Reader)new StringReader(pemEncodedCert));
        try {
            Object parsed = pemParser.readObject();
            if (parsed instanceof X509CertificateHolder) {
                X509CertificateHolder certificate = (X509CertificateHolder)parsed;
                return new JcaX509CertificateConverter().getCertificate(certificate);
            }
            throw new IllegalArgumentException("Couldn't parse x509 certificate from provided string, unknown type");
        }
        catch (IOException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getfingerprint(X509Certificate cert, String type) {
        try {
            MessageDigest md = MessageDigest.getInstance(type);
            byte[] der = cert.getEncoded();
            md.update(der);
            byte[] digest = md.digest();
            String digestHex = Hex.encodeHexString((byte[])digest);
            return digestHex.toLowerCase(Locale.ROOT);
        }
        catch (NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

