/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.common.collect.Streams;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog2.indexer.results.ChunkedQueryResult;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ResultMessageFactory;

public abstract class ChunkedQueryResultOS2
extends ChunkedQueryResult<OpenSearchClient, SearchResponse> {
    private final ResultMessageFactory resultMessageFactory;

    public ChunkedQueryResultOS2(ResultMessageFactory resultMessageFactory, OpenSearchClient client, SearchResponse initialResult, String query, List<String> fields, int limit) {
        super((Object)client, (Object)initialResult, query, fields, limit);
        this.resultMessageFactory = resultMessageFactory;
    }

    protected List<ResultMessage> collectMessagesFromResult(SearchResponse result) {
        return Streams.stream((Iterable)result.getHits()).map(hit -> this.resultMessageFactory.parseFromSource(hit.getId(), hit.getIndex(), hit.getSourceAsMap())).collect(Collectors.toList());
    }

    protected long countTotalHits(SearchResponse response) {
        return response.getHits().getTotalHits().value;
    }

    protected long getTookMillisFromResponse(SearchResponse response) {
        return response.getTook().getMillis();
    }
}

