/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.ComposableIndexTemplateExistRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.DeleteComposableIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.PutComposableIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.CompressedXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.storage.opensearch2.IndexTemplateAdapter;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog2.indexer.indices.Template;

public class ComposableIndexTemplateAdapter
implements IndexTemplateAdapter {
    private final OpenSearchClient client;
    private final ObjectMapper objectMapper;

    @Inject
    public ComposableIndexTemplateAdapter(OpenSearchClient client, ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
    }

    @Override
    public boolean ensureIndexTemplate(String templateName, Template template) {
        CompressedXContent serializedMapping = this.serialize(template.mappings());
        Settings settings = Settings.builder().loadFromMap((Map<String, ?>)template.settings()).build();
        org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Template osTemplate = new org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Template(settings, serializedMapping, null);
        ComposableIndexTemplate indexTemplate = new ComposableIndexTemplate(template.indexPatterns(), osTemplate, null, template.order(), null, null);
        PutComposableIndexTemplateRequest request = new PutComposableIndexTemplateRequest().name(templateName).indexTemplate(indexTemplate);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().putIndexTemplate(request, (RequestOptions)requestOptions), "Unable to create index template " + templateName);
        return result.isAcknowledged();
    }

    private CompressedXContent serialize(Object obj) {
        try {
            return new CompressedXContent(this.objectMapper.writeValueAsString(obj));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean indexTemplateExists(String templateName) {
        return this.client.execute((c, requestOptions) -> c.indices().existsIndexTemplate(new ComposableIndexTemplateExistRequest(templateName), (RequestOptions)requestOptions), "Unable to verify index template existence " + templateName);
    }

    @Override
    public boolean deleteIndexTemplate(String templateName) {
        DeleteComposableIndexTemplateRequest request = new DeleteComposableIndexTemplateRequest(templateName);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().deleteIndexTemplate(request, (RequestOptions)requestOptions), "Unable to delete index template " + templateName);
        return result.isAcknowledged();
    }
}

