/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.fasterxml.jackson.annotation.JsonInclude;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bouncycastle.openssl.jcajce.JcaPEMWriter;
import org.graylog.storage.opensearch2.ConnectionCheckIndex;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public record ConnectionCheckResponse(List<ConnectionCheckIndex> indices, List<String> certificates, String error) {
    public static ConnectionCheckResponse success(List<ConnectionCheckIndex> indices, List<X509Certificate> certificates) {
        return new ConnectionCheckResponse(indices, ConnectionCheckResponse.encodeCerts(certificates), null);
    }

    public static ConnectionCheckResponse error(Exception e, List<X509Certificate> certificates) {
        return new ConnectionCheckResponse(Collections.emptyList(), ConnectionCheckResponse.encodeCerts(certificates), e.getMessage());
    }

    @Nonnull
    private static List<String> encodeCerts(List<X509Certificate> trustedCertificates) {
        return Optional.ofNullable(trustedCertificates).map(certs -> certs.stream().map(ConnectionCheckResponse::encode).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    private static String encode(X509Certificate certificate) {
        StringWriter writer = new StringWriter();
        try (JcaPEMWriter jcaPEMWriter = new JcaPEMWriter((Writer)writer);){
            jcaPEMWriter.writeObject((Object)certificate);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return writer.toString();
    }
}

