/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.CreateDataStreamRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.DataStream;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.DeleteComposableIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.DeleteDataStreamRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.GetDataStreamRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.GetDataStreamResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.PutComposableIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.PutIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.ComposableIndexTemplate;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.DataStream;
import org.graylog.shaded.opensearch2.org.opensearch.common.compress.CompressedXContent;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.ism.IsmApi;
import org.graylog2.indexer.datastream.DataStreamAdapter;
import org.graylog2.indexer.datastream.Policy;
import org.graylog2.indexer.datastream.policy.IsmPolicy;
import org.graylog2.indexer.indices.Template;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataStreamAdapterOS2
implements DataStreamAdapter {
    private final Logger log = LoggerFactory.getLogger(DataStreamAdapterOS2.class);
    private final OpenSearchClient client;
    private final ObjectMapper objectMapper;
    private final IsmApi ismApi;

    @Inject
    public DataStreamAdapterOS2(OpenSearchClient client, ObjectMapper objectMapper, IsmApi ismApi) {
        this.client = client;
        this.objectMapper = objectMapper;
        this.ismApi = ismApi;
    }

    public boolean ensureDataStreamTemplate(@Nonnull String templateName, @Nonnull Template template, @Nonnull String timestampField) {
        ComposableIndexTemplate.DataStreamTemplate datastreamTemplate = new ComposableIndexTemplate.DataStreamTemplate(new DataStream.TimestampField(timestampField));
        CompressedXContent serializedMapping = null;
        try {
            serializedMapping = new CompressedXContent(this.objectMapper.writeValueAsString((Object)template.mappings()));
        }
        catch (IOException e) {
            throw new RuntimeException("Could not serialize mappings for data stream", e);
        }
        Settings settings = Settings.builder().loadFromMap((Map<String, ?>)template.settings()).build();
        org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Template osTemplate = new org.graylog.shaded.opensearch2.org.opensearch.cluster.metadata.Template(settings, serializedMapping, null);
        ComposableIndexTemplate indexTemplate = new ComposableIndexTemplate(template.indexPatterns(), osTemplate, null, template.order(), null, null, datastreamTemplate);
        PutComposableIndexTemplateRequest request = new PutComposableIndexTemplateRequest().name(templateName).indexTemplate(indexTemplate);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().putIndexTemplate(request, (RequestOptions)requestOptions), "Unable to create data stream template " + templateName);
        return result.isAcknowledged();
    }

    protected boolean deleteDataStreamTemplate(@Nonnull String templateName) {
        DeleteComposableIndexTemplateRequest request = new DeleteComposableIndexTemplateRequest(templateName);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().deleteIndexTemplate(request, (RequestOptions)requestOptions), "Unable to delete data stream template " + templateName);
        return result.isAcknowledged();
    }

    public void createDataStream(@Nonnull String dataStreamName) {
        CreateDataStreamRequest createDataStreamRequest = new CreateDataStreamRequest(dataStreamName);
        try {
            this.client.execute((c, requestOptions) -> c.indices().createDataStream(createDataStreamRequest, (RequestOptions)requestOptions));
        }
        catch (OpenSearchException e) {
            if (e.getDetailedMessage().contains("resource_already_exists_exception")) {
                this.log.debug("Data stream {} already exists, won't be created again", (Object)createDataStreamRequest.getName());
            }
            throw e;
        }
    }

    public void setNumberOfReplicas(@Nonnull String dataStreamName, int replicas) {
        UpdateSettingsRequest req = new UpdateSettingsRequest().indices(".opendistro-ism*");
        req.settings(Map.of("number_of_replicas", replicas));
        try {
            this.client.execute((c, requestOptions) -> c.indices().putSettings(req, (RequestOptions)requestOptions));
        }
        catch (Exception e) {
            this.log.debug("Could not set replicas for .opendistro-ism system indices");
        }
        req.indices(".opendistro-job-scheduler-lock");
        try {
            this.client.execute((c, requestOptions) -> c.indices().putSettings(req, (RequestOptions)requestOptions));
        }
        catch (Exception e) {
            this.log.debug("Could not set replicas for .opendistro-job-scheduler-lock system index. It might not exist yet.");
        }
        req.indices(dataStreamName);
        PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest("data-stream-system-indices");
        templateRequest.patterns(List.of(".opendistro-job-scheduler-lock"));
        templateRequest.settings(Settings.builder().put("number_of_replicas", replicas).build());
        try {
            this.client.execute((c, requestOptions) -> c.indices().putTemplate(templateRequest, (RequestOptions)requestOptions));
        }
        catch (Exception e) {
            this.log.debug("Could not set replicas for data stream system indices");
        }
        ClusterUpdateSettingsRequest settingsRequest = new ClusterUpdateSettingsRequest();
        settingsRequest.persistentSettings(Settings.builder().put("opendistro.index_state_management.history.number_of_replicas", replicas).build());
        try {
            this.client.execute((c, requestOptions) -> c.cluster().putSettings(settingsRequest, (RequestOptions)requestOptions));
        }
        catch (Exception e) {
            this.log.debug("Could not set default replicas for ism history");
        }
        try {
            this.client.execute((c, requestOptions) -> c.indices().putSettings(req, (RequestOptions)requestOptions));
        }
        catch (Exception e) {
            this.log.debug("Could not set replicas for data stream {}", (Object)dataStreamName);
        }
    }

    public boolean deleteDataStream(@Nonnull String dataStreamName) {
        return this.client.execute((c, requestOptions) -> c.indices().deleteDataStream(new DeleteDataStreamRequest(dataStreamName), (RequestOptions)requestOptions)).isAcknowledged();
    }

    protected List<DataStream> getDataStream(@Nonnull String dataStreamName) {
        GetDataStreamResponse dataStream = this.client.execute((c, requestOptions) -> c.indices().getDataStream(new GetDataStreamRequest(dataStreamName), (RequestOptions)requestOptions));
        return dataStream.getDataStreams();
    }

    public void applyIsmPolicy(@Nonnull String dataStreamName, @Nonnull Policy policy) {
        Optional<Object> osPolicy;
        IsmPolicy ismPolicy = (IsmPolicy)policy;
        String id = ismPolicy.id();
        if (Objects.isNull(id)) {
            throw new IllegalArgumentException("Policy Id may not be null");
        }
        try {
            osPolicy = this.ismApi.getPolicy(id);
        }
        catch (Exception e) {
            this.ismApi.removePolicyFromIndex(dataStreamName);
            this.ismApi.deletePolicy(id);
            osPolicy = Optional.empty();
        }
        if (osPolicy.isPresent()) {
            this.ismApi.removePolicyFromIndex(dataStreamName);
            this.ismApi.deletePolicy(id);
        }
        this.ismApi.createPolicy(ismPolicy.id(), new IsmPolicy(ismPolicy.policy()));
        this.ismApi.addPolicyToIndex(id, dataStreamName);
    }

    public void deleteIsmPolicy(@Nonnull String policyId) {
        this.ismApi.deletePolicy(policyId);
    }
}

