/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.graylog.plugins.datanode.DatanodeUpgradeServiceAdapter;
import org.graylog.plugins.datanode.dto.ClusterState;
import org.graylog.plugins.datanode.dto.FlushResponse;
import org.graylog.plugins.datanode.dto.ManagerNode;
import org.graylog.plugins.datanode.dto.Node;
import org.graylog.plugins.datanode.dto.ShardReplication;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.health.ClusterHealthRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.health.ClusterHealthResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterGetSettingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterGetSettingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.cluster.settings.ClusterUpdateSettingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.shaded.opensearch2.org.opensearch.cluster.health.ClusterHealthStatus;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatanodeUpgradeServiceAdapterOS2
implements DatanodeUpgradeServiceAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(DatanodeUpgradeServiceAdapterOS2.class);
    public static final String REPLICATION_PRIMARIES = "primaries";
    public static final String REPLICATION_ALL = "all";
    private final OpenSearchClient client;
    private final ObjectMapper objectMapper;

    @Inject
    public DatanodeUpgradeServiceAdapterOS2(OpenSearchClient client, ObjectMapper objectMapper) {
        this.client = client;
        this.objectMapper = objectMapper;
    }

    public ClusterState getClusterState() {
        ClusterHealthResponse response = this.getClusterHealthResponse();
        String shardReplication = this.queryShardReplication();
        ManagerNode managerNode = this.managerNode();
        return new ClusterState(response.getStatus().name(), response.getClusterName(), response.getNumberOfNodes(), response.getActiveShards(), response.getRelocatingShards(), response.getInitializingShards(), response.getUnassignedShards(), response.getActivePrimaryShards(), response.getDelayedUnassignedShards(), Optional.ofNullable(shardReplication).map(v -> v.toUpperCase(Locale.ROOT)).map(ShardReplication::valueOf).orElse(ShardReplication.ALL), managerNode, this.nodesResponse());
    }

    private ClusterHealthResponse getClusterHealthResponse() {
        return this.client.execute((restHighLevelClient, requestOptions) -> restHighLevelClient.cluster().health(new ClusterHealthRequest(), (RequestOptions)requestOptions));
    }

    public void disableShardReplication() {
        LOG.info("Disabling shard replication for opensearch cluster");
        ClusterHealthStatus clusterHealthStatus = this.getClusterHealthResponse().getStatus();
        if (clusterHealthStatus != ClusterHealthStatus.GREEN) {
            throw new IllegalStateException("Can't disable shard replication, cluster is not in healthy state. Current state: " + String.valueOf(clusterHealthStatus));
        }
        this.configureShardReplication(REPLICATION_PRIMARIES);
    }

    public void enableShardReplication() {
        LOG.info("Enabling shard replication for opensearch cluster");
        this.configureShardReplication(REPLICATION_ALL);
    }

    private String queryShardReplication() {
        return this.client.execute((restHighLevelClient, requestOptions) -> {
            ClusterGetSettingsResponse settings = restHighLevelClient.cluster().getSettings(new ClusterGetSettingsRequest().includeDefaults(true), (RequestOptions)requestOptions);
            return settings.getPersistentSettings().get("cluster.routing.allocation.enable");
        });
    }

    private void configureShardReplication(String primaries) {
        ClusterUpdateSettingsRequest request = new ClusterUpdateSettingsRequest().persistentSettings(Settings.builder().put("cluster.routing.allocation.enable", primaries).build());
        ClusterUpdateSettingsResponse result = this.client.execute((restHighLevelClient, requestOptions) -> restHighLevelClient.cluster().putSettings(request, (RequestOptions)requestOptions));
        String value = result.getPersistentSettings().get("cluster.routing.allocation.enable");
        if (!value.equals(primaries)) {
            throw new IllegalStateException("Failed to disable shard replication. Current cluster.routing.allocation.enable: " + value);
        }
    }

    public FlushResponse flush() {
        LOG.info("Flushing opensearch nodes, storing all in-memory operations to segments on disk");
        Response response = this.client.execute((restHighLevelClient, requestOptions) -> restHighLevelClient.getLowLevelClient().performRequest(new Request("POST", "_flush")));
        try {
            JsonNode flushResponse = (JsonNode)this.objectMapper.readValue(response.getEntity().getContent(), JsonNode.class);
            JsonNode shards = flushResponse.path("_shards");
            return new FlushResponse(shards.path("total").asInt(), shards.path("successful").asInt(), shards.path("failed").asInt());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Node> nodesResponse() {
        Response nodes = this.client.execute((restHighLevelClient, requestOptions) -> restHighLevelClient.getLowLevelClient().performRequest(new Request("GET", "_nodes")));
        try {
            JsonNode parsed = (JsonNode)this.objectMapper.readValue(nodes.getEntity().getContent(), JsonNode.class);
            return this.parseNodes(parsed.path("nodes"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private ManagerNode managerNode() {
        Response nodes = this.client.execute((restHighLevelClient, requestOptions) -> restHighLevelClient.getLowLevelClient().performRequest(new Request("GET", "_cluster/state")));
        try {
            JsonNode parsed = (JsonNode)this.objectMapper.readValue(nodes.getEntity().getContent(), JsonNode.class);
            String managerNodeID = parsed.path("cluster_manager_node").asText();
            String managerNodeName = parsed.path("nodes").path(managerNodeID).path("name").asText();
            return new ManagerNode(managerNodeID, managerNodeName);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Node> parseNodes(JsonNode nodes) {
        return StreamSupport.stream(nodes.spliterator(), false).map(node -> new Node(node.path("host").asText(), node.path("ip").asText(), node.path("name").asText(), node.path("version").asText(), this.parseRoles(node.path("roles")))).sorted(Comparator.comparing(Node::name)).collect(Collectors.toList());
    }

    private List<String> parseRoles(JsonNode roles) {
        return StreamSupport.stream(roles.spliterator(), false).map(JsonNode::asText).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
    }
}

