/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import jakarta.inject.Inject;
import java.util.Map;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.master.AcknowledgedResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.IndexTemplatesExistRequest;
import org.graylog.shaded.opensearch2.org.opensearch.client.indices.PutIndexTemplateRequest;
import org.graylog.storage.opensearch2.IndexTemplateAdapter;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog2.indexer.indices.Template;

public class LegacyIndexTemplateAdapter
implements IndexTemplateAdapter {
    private final OpenSearchClient client;

    @Inject
    public LegacyIndexTemplateAdapter(OpenSearchClient client) {
        this.client = client;
    }

    @Override
    public boolean ensureIndexTemplate(String templateName, Template template) {
        Map<String, Object> templateSource = Map.of("index_patterns", template.indexPatterns(), "mappings", template.mappings(), "settings", template.settings(), "order", template.order());
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(templateName).source(templateSource);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().putTemplate(request, (RequestOptions)requestOptions), "Unable to create index template " + templateName);
        return result.isAcknowledged();
    }

    @Override
    public boolean indexTemplateExists(String templateName) {
        return this.client.execute((c, requestOptions) -> c.indices().existsTemplate(new IndexTemplatesExistRequest(templateName), (RequestOptions)requestOptions), "Unable to verify index template existence " + templateName);
    }

    @Override
    public boolean deleteIndexTemplate(String templateName) {
        DeleteIndexTemplateRequest request = new DeleteIndexTemplateRequest(templateName);
        AcknowledgedResponse result = this.client.execute((c, requestOptions) -> c.indices().deleteTemplate(request, (RequestOptions)requestOptions), "Unable to delete index template " + templateName);
        return result.isAcknowledged();
    }
}

