/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.common.base.Stopwatch;
import com.google.common.base.Strings;
import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.graylog.events.processor.EventProcessorException;
import org.graylog.events.search.MoreSearch;
import org.graylog.events.search.MoreSearchAdapter;
import org.graylog.plugins.views.search.searchfilters.model.UsedSearchFilter;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.AutoInterval;
import org.graylog.plugins.views.search.searchtypes.pivot.buckets.DateInterval;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.MatchAllQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.Histogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.LongBounds;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.histogram.ParsedDateHistogram;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.ParsedTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;
import org.graylog.storage.opensearch2.OS2ResultMessageFactory;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.SortOrderMapper;
import org.graylog.storage.opensearch2.TimeRangeQueryFactory;
import org.graylog2.indexer.results.ChunkedResult;
import org.graylog2.indexer.results.MultiChunkResultRetriever;
import org.graylog2.indexer.results.ResultChunk;
import org.graylog2.indexer.searches.ChunkCommand;
import org.graylog2.indexer.searches.Sorting;
import org.graylog2.plugin.Tools;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoreSearchAdapterOS2
implements MoreSearchAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(MoreSearchAdapterOS2.class);
    public static final IndicesOptions INDICES_OPTIONS = IndicesOptions.LENIENT_EXPAND_OPEN;
    private static final String termsAggregationName = "alert_type";
    private static final String histogramAggregationName = "histogram";
    private final OpenSearchClient client;
    private final Boolean allowLeadingWildcard;
    private final SortOrderMapper sortOrderMapper;
    private final MultiChunkResultRetriever multiChunkResultRetriever;
    private final OS2ResultMessageFactory resultMessageFactory;

    @Inject
    public MoreSearchAdapterOS2(OpenSearchClient client, @Named(value="allow_leading_wildcard_searches") Boolean allowLeadingWildcard, SortOrderMapper sortOrderMapper, MultiChunkResultRetriever multiChunkResultRetriever, OS2ResultMessageFactory resultMessageFactory) {
        this.client = client;
        this.allowLeadingWildcard = allowLeadingWildcard;
        this.sortOrderMapper = sortOrderMapper;
        this.multiChunkResultRetriever = multiChunkResultRetriever;
        this.resultMessageFactory = resultMessageFactory;
    }

    public MoreSearch.Result eventSearch(String queryString, TimeRange timerange, Set<String> affectedIndices, Sorting sorting, int page, int perPage, Set<String> eventStreams, String filterString, Set<String> forbiddenSourceStreams, Map<String, Set<String>> extraFilters) {
        QueryBuilder filter = this.createQuery(queryString, timerange, eventStreams, filterString, forbiddenSourceStreams, extraFilters);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filter).from((page - 1) * perPage).size(perPage).trackTotalHits(true);
        List<FieldSortBuilder> sortBuilders = this.createSorting(sorting);
        sortBuilders.forEach(searchSourceBuilder::sort);
        Set<String> indices = affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices;
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[0])).source(searchSourceBuilder).indicesOptions(INDICES_OPTIONS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString(new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchRequest);
        }
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to perform search query");
        List hits = Streams.stream((Iterable)searchResult.getHits()).map(this.resultMessageFactory::fromSearchHit).collect(Collectors.toList());
        long total = searchResult.getHits().getTotalHits().value;
        return MoreSearch.Result.builder().results(hits).resultsCount(total).duration(searchResult.getTook().getMillis()).usedIndexNames(affectedIndices).executedQuery(searchSourceBuilder.toString()).build();
    }

    public MoreSearch.Histogram eventHistogram(String queryString, AbsoluteRange timerange, Set<String> affectedIndices, Set<String> eventStreams, String filterString, Set<String> forbiddenSourceStreams, ZoneId timeZone, Map<String, Set<String>> extraFilters) {
        QueryBuilder filter = this.createQuery(queryString, (TimeRange)timerange, eventStreams, filterString, forbiddenSourceStreams, extraFilters);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(filter).size(0).trackTotalHits(true);
        AutoInterval autoInterval = AutoInterval.create();
        DateInterval interval = autoInterval.toDateInterval((TimeRange)timerange);
        DateHistogramAggregationBuilder histogramAggregation = ((DateHistogramAggregationBuilder)((DateHistogramAggregationBuilder)new DateHistogramAggregationBuilder(histogramAggregationName).field("timestamp")).timeZone(timeZone)).minDocCount(0L).extendedBounds(new LongBounds(Tools.buildElasticSearchTimeFormat((DateTime)timerange.from()), Tools.buildElasticSearchTimeFormat((DateTime)timerange.to())));
        DateHistogramInterval dateInterval = new DateHistogramInterval(interval.getQuantity().toString() + interval.getUnit());
        if (interval.getQuantity().intValue() > 1) {
            histogramAggregation.fixedInterval(dateInterval);
        } else {
            histogramAggregation.calendarInterval(dateInterval);
        }
        TermsAggregationBuilder termsAggregation = (TermsAggregationBuilder)AggregationBuilders.terms(termsAggregationName).minDocCount(0L).field("alert");
        searchSourceBuilder.aggregation(histogramAggregation.subAggregation(termsAggregation));
        Set<String> indices = affectedIndices.isEmpty() ? Collections.singleton("") : affectedIndices;
        SearchRequest searchRequest = new SearchRequest(indices.toArray(new String[0])).source(searchSourceBuilder).indicesOptions(INDICES_OPTIONS);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Query:\n{}", (Object)searchSourceBuilder.toString(new ToXContent.MapParams(Collections.singletonMap("pretty", "true"))));
            LOG.debug("Execute search: {}", (Object)searchRequest);
        }
        SearchResponse searchResult = this.client.search(searchRequest, "Unable to perform search query");
        ParsedDateHistogram histogramResult = (ParsedDateHistogram)searchResult.getAggregations().get(histogramAggregationName);
        List<? extends Histogram.Bucket> histogramBuckets = histogramResult.getBuckets();
        ArrayList alerts = new ArrayList(histogramBuckets.size());
        ArrayList events = new ArrayList(histogramBuckets.size());
        histogramBuckets.forEach(bucket -> {
            ParsedTerms parsedTerms = (ParsedTerms)bucket.getAggregations().get(termsAggregationName);
            ZonedDateTime dateTime = ((ZonedDateTime)bucket.getKey()).withZoneSameInstant(timeZone);
            Long alertCount = Optional.ofNullable(parsedTerms.getBucketByKey("true")).map(MultiBucketsAggregation.Bucket::getDocCount).orElse(0L);
            Long eventCount = Optional.ofNullable(parsedTerms.getBucketByKey("false")).map(MultiBucketsAggregation.Bucket::getDocCount).orElse(0L);
            alerts.add(new MoreSearch.Histogram.Bucket(dateTime, alertCount));
            events.add(new MoreSearch.Histogram.Bucket(dateTime, eventCount));
        });
        return new MoreSearch.Histogram(new MoreSearch.Histogram.EventsBuckets(events, alerts));
    }

    private QueryBuilder createQuery(String queryString, TimeRange timerange, Set<String> eventStreams, String filterString, Set<String> forbiddenSourceStreams, Map<String, Set<String>> extraFilters) {
        MatchAllQueryBuilder query = queryString.isEmpty() || queryString.equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(queryString).allowLeadingWildcard(this.allowLeadingWildcard);
        BoolQueryBuilder filter = QueryBuilders.boolQuery().filter(query).filter(QueryBuilders.termsQuery("streams", eventStreams)).filter(Objects.requireNonNull(TimeRangeQueryFactory.create(timerange)));
        extraFilters.entrySet().stream().flatMap(extraFilter -> ((Set)extraFilter.getValue()).stream().map(value -> MoreSearchAdapterOS2.buildExtraFilter((String)extraFilter.getKey(), value))).forEach(filter::filter);
        if (!Strings.isNullOrEmpty((String)filterString)) {
            filter.filter(QueryBuilders.queryStringQuery(filterString));
        }
        if (!forbiddenSourceStreams.isEmpty()) {
            filter.filter(QueryBuilders.boolQuery().mustNot(QueryBuilders.termsQuery("source_streams", forbiddenSourceStreams)));
        }
        return filter;
    }

    static QueryBuilder buildExtraFilter(String field, String value) {
        if (value.startsWith("<=")) {
            return QueryBuilders.rangeQuery(field).lte(value.replace("<=", ""));
        }
        if (value.startsWith(">=")) {
            return QueryBuilders.rangeQuery(field).gte(value.replace(">=", ""));
        }
        if (value.startsWith("<")) {
            return QueryBuilders.rangeQuery(field).lt(value.replace("<", ""));
        }
        if (value.startsWith(">")) {
            return QueryBuilders.rangeQuery(field).gt(value.replace(">", ""));
        }
        return QueryBuilders.multiMatchQuery(value, field);
    }

    private List<FieldSortBuilder> createSorting(Sorting sorting) {
        SortOrder order = this.sortOrderMapper.fromSorting(sorting);
        List<FieldSortBuilder> sortBuilders = "timerange_start".equals(sorting.getField()) ? List.of(new FieldSortBuilder("timerange_start"), new FieldSortBuilder("timerange_end")) : List.of(new FieldSortBuilder(sorting.getField()));
        return sortBuilders.stream().map(sortBuilder -> {
            sorting.getUnmappedType().ifPresent(unmappedType -> sortBuilder.unmappedType((String)unmappedType).missing(order.equals(SortOrder.ASC) ? "_first" : "_last"));
            return (FieldSortBuilder)sortBuilder.order(order);
        }).toList();
    }

    public void scrollEvents(String queryString, TimeRange timeRange, Set<String> affectedIndices, Set<String> streams, List<UsedSearchFilter> filters, int batchSize, MoreSearchAdapter.ScrollEventsCallback resultCallback) throws EventProcessorException {
        ChunkCommand chunkCommand = this.buildScrollCommand(queryString, timeRange, affectedIndices, filters, streams, batchSize);
        ChunkedResult chunkedResult = this.multiChunkResultRetriever.retrieveChunkedResult(chunkCommand);
        AtomicBoolean continueScrolling = new AtomicBoolean(true);
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            ResultChunk resultChunk = chunkedResult.nextChunk();
            while (continueScrolling.get() && resultChunk != null) {
                List messages = resultChunk.messages();
                LOG.debug("Passing <{}> messages to callback", (Object)messages.size());
                resultCallback.accept(Collections.unmodifiableList(messages), continueScrolling);
                if (!continueScrolling.get()) {
                    break;
                }
                resultChunk = chunkedResult.nextChunk();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        finally {
            try {
                chunkedResult.cancel();
            }
            catch (Exception exception) {}
            LOG.debug("Scrolling done - took {} ms", (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
        }
    }

    private ChunkCommand buildScrollCommand(String queryString, TimeRange timeRange, Set<String> affectedIndices, List<UsedSearchFilter> filters, Set<String> streams, int batchSize) {
        ChunkCommand.Builder commandBuilder = ChunkCommand.builder().query(queryString).range(timeRange).indices(affectedIndices).filters(filters == null ? Collections.emptyList() : filters).batchSize(batchSize).sorting(new Sorting("timestamp", Sorting.Direction.ASC));
        if (!streams.isEmpty()) {
            commandBuilder = commandBuilder.streams(streams);
        }
        return commandBuilder.build();
    }
}

