/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import jakarta.inject.Inject;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.core.common.text.Text;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.search.fetch.subphase.highlight.HighlightField;
import org.graylog2.indexer.results.ResultMessage;
import org.graylog2.indexer.results.ResultMessageFactory;

public class OS2ResultMessageFactory {
    private final ResultMessageFactory messageFactory;

    @Inject
    public OS2ResultMessageFactory(ResultMessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public ResultMessage fromSearchHit(SearchHit hit) {
        Map<String, List> highlights = hit.getHighlightFields().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, OS2ResultMessageFactory::highlightsFromFragments));
        return this.messageFactory.parseFromSource(hit.getId(), hit.getIndex(), hit.getSourceAsMap(), highlights);
    }

    private static List<String> highlightsFromFragments(Map.Entry<String, HighlightField> entry) {
        return Arrays.stream(entry.getValue().fragments()).map(Text::toString).collect(Collectors.toList());
    }
}

