/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.github.zafarkhaja.semver.Version;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.storage.opensearch2.OpenSearch2Metadata;
import org.graylog.storage.opensearch2.OpenSearch2Module;
import org.graylog.storage.opensearch2.ViewsOSBackendModule;
import org.graylog2.featureflag.FeatureFlags;
import org.graylog2.plugin.Plugin;
import org.graylog2.plugin.PluginMetaData;
import org.graylog2.plugin.PluginModule;
import org.graylog2.plugin.VersionAwareModule;
import org.graylog2.storage.SearchVersion;

public class OpenSearch2Plugin
implements Plugin {
    public static final Set<SearchVersion> SUPPORTED_OS_VERSIONS = ImmutableSet.of((Object)SearchVersion.create((SearchVersion.Distribution)SearchVersion.Distribution.OPENSEARCH, (Version)Version.of((long)2L, (long)0L, (long)0L)), (Object)SearchVersion.create((SearchVersion.Distribution)SearchVersion.Distribution.DATANODE, (Version)Version.of((long)5L, (long)0L, (long)0L)));
    @Inject
    private FeatureFlags featureFlags;

    public PluginMetaData metadata() {
        return new OpenSearch2Metadata();
    }

    public Collection<PluginModule> modules() {
        boolean useComposableIndexTemplates = this.featureFlags.isOn("composable_index_templates");
        return SUPPORTED_OS_VERSIONS.stream().flatMap(version -> Stream.of(new VersionAwareModule[]{new OpenSearch2Module((SearchVersion)version, useComposableIndexTemplates), new ViewsOSBackendModule((SearchVersion)version)})).collect(Collectors.toList());
    }
}

