/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import jakarta.inject.Inject;
import java.util.Set;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.PaginationResultOS2;
import org.graylog.storage.opensearch2.SearchRequestFactory;
import org.graylog2.indexer.results.ChunkedResult;
import org.graylog2.indexer.results.MultiChunkResultRetriever;
import org.graylog2.indexer.results.ResultMessageFactory;
import org.graylog2.indexer.searches.ChunkCommand;

public class PaginationOS2
implements MultiChunkResultRetriever {
    private final ResultMessageFactory resultMessageFactory;
    private final OpenSearchClient client;
    private final SearchRequestFactory searchRequestFactory;

    @Inject
    public PaginationOS2(ResultMessageFactory resultMessageFactory, OpenSearchClient client, SearchRequestFactory searchRequestFactory) {
        this.resultMessageFactory = resultMessageFactory;
        this.client = client;
        this.searchRequestFactory = searchRequestFactory;
    }

    public ChunkedResult retrieveChunkedResult(ChunkCommand chunkCommand) {
        SearchSourceBuilder searchQuery = this.searchRequestFactory.create(chunkCommand);
        SearchRequest request = this.buildSearchRequest(searchQuery, chunkCommand.indices());
        SearchResponse result = this.client.search(request, "Unable to perform search-after pagination search");
        return new PaginationResultOS2(this.resultMessageFactory, this.client, request, result, searchQuery.toString(), chunkCommand.fields(), chunkCommand.limit().orElse(-1));
    }

    private SearchRequest buildSearchRequest(SearchSourceBuilder query, Set<String> indices) {
        return new SearchRequest(indices.toArray(new String[0])).source(query).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
    }
}

