/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.opensearch2.ChunkedQueryResultOS2;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog2.indexer.results.ResultMessageFactory;

public class PaginationResultOS2
extends ChunkedQueryResultOS2 {
    private final SearchRequest initialSearchRequest;

    @AssistedInject
    public PaginationResultOS2(ResultMessageFactory resultMessageFactory, OpenSearchClient client, SearchRequest initialSearchRequest, @Assisted SearchResponse initialResult, @Assisted(value="query") String query, @Assisted List<String> fields, @Assisted int limit) {
        super(resultMessageFactory, client, initialResult, query, fields, limit);
        this.initialSearchRequest = initialSearchRequest;
    }

    @Nullable
    protected SearchResponse nextSearchResult() {
        SearchSourceBuilder initialQuery = this.initialSearchRequest.source();
        SearchHit[] hits = ((SearchResponse)this.lastSearchResponse).getHits().getHits();
        if (hits == null || hits.length == 0) {
            return null;
        }
        initialQuery.searchAfter(hits[hits.length - 1].getSortValues());
        this.initialSearchRequest.source(initialQuery);
        return ((OpenSearchClient)this.client).search(this.initialSearchRequest, "Unable to retrieve next chunk from search: ");
    }

    protected String getChunkingMethodName() {
        return "search-after pagination";
    }

    public void cancel() {
    }
}

