/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.auto.value.AutoValue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.graylog.storage.opensearch2.AutoValue_ParsedOpenSearchException;

@AutoValue
public abstract class ParsedOpenSearchException {
    private static final Pattern exceptionPattern = Pattern.compile("(OpenSearchException\\[)?OpenSearch exception \\[type=(?<type>[\\w_]+), (?:reason=(?<reason>.+?)(\\]+;|\\]$))");

    public abstract String type();

    public abstract String reason();

    public static ParsedOpenSearchException create(String type, String reason) {
        return new AutoValue_ParsedOpenSearchException(type, reason);
    }

    public static ParsedOpenSearchException from(String s) {
        Matcher matcher = exceptionPattern.matcher(s);
        if (matcher.find()) {
            String type = matcher.group("type");
            String reason = matcher.group("reason");
            return ParsedOpenSearchException.create(type, reason);
        }
        throw new IllegalArgumentException("Unable to parse OpenSearch exception: " + s);
    }
}

