/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.storage.opensearch2.OpenSearchClient;

public class PlainJsonApi {
    private final ObjectMapper objectMapper;
    private final OpenSearchClient client;

    @Inject
    public PlainJsonApi(ObjectMapper objectMapper, OpenSearchClient client) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public JsonNode perform(Request request, String errorMessage) {
        return this.client.execute((c, requestOptions) -> {
            request.setOptions((RequestOptions)requestOptions);
            Response response = c.getLowLevelClient().performRequest(request);
            return this.objectMapper.readTree(response.getEntity().getContent());
        }, errorMessage);
    }
}

