/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.graylog.shaded.opensearch2.org.apache.http.entity.ContentType;
import org.graylog.shaded.opensearch2.org.apache.http.entity.InputStreamEntity;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseException;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestHighLevelClient;
import org.graylog.storage.opensearch2.RestClientProvider;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.indexer.datanode.ProxyRequestAdapter;
import org.graylog2.rest.resources.datanodes.DatanodeResolver;

public class ProxyRequestAdapterOS2
implements ProxyRequestAdapter {
    private final RestClientProvider restClientProvider;
    private final DatanodeResolver datanodeResolver;

    @Inject
    public ProxyRequestAdapterOS2(RestClientProvider restClientProvider, DatanodeResolver datanodeResolver) {
        this.restClientProvider = restClientProvider;
        this.datanodeResolver = datanodeResolver;
    }

    public ProxyRequestAdapter.ProxyResponse request(ProxyRequestAdapter.ProxyRequest request) throws IOException {
        ProxyRequestAdapter.ProxyResponse proxyResponse;
        block9: {
            Request req = new Request(request.method(), request.path());
            request.queryParameters().forEach((key, values) -> values.forEach(value -> req.addParameter((String)key, (String)value)));
            req.setEntity(new InputStreamEntity(request.body(), ContentType.APPLICATION_JSON));
            RestHighLevelClient restClient = this.buildClient(request);
            try {
                Response osResponse = restClient.getLowLevelClient().performRequest(req);
                proxyResponse = new ProxyRequestAdapter.ProxyResponse(osResponse.getStatusLine().getStatusCode(), osResponse.getEntity().getContent(), osResponse.getEntity().getContentType().getValue());
                if (restClient == null) break block9;
            }
            catch (Throwable osResponse) {
                try {
                    if (restClient != null) {
                        try {
                            restClient.close();
                        }
                        catch (Throwable throwable) {
                            osResponse.addSuppressed(throwable);
                        }
                    }
                    throw osResponse;
                }
                catch (OpenSearchException openSearchException) {
                    Throwable cause = openSearchException.getCause();
                    if (cause instanceof ResponseException) {
                        ResponseException responseException = (ResponseException)cause;
                        Response response = responseException.getResponse();
                        int status = response.getStatusLine().getStatusCode();
                        return ProxyRequestAdapterOS2.getProxyResponse(status, response);
                    }
                    throw openSearchException;
                }
            }
            restClient.close();
        }
        return proxyResponse;
    }

    @Nonnull
    private static ProxyRequestAdapter.ProxyResponse getProxyResponse(int status, Response response) throws IOException {
        return new ProxyRequestAdapter.ProxyResponse(status, response.getEntity().getContent(), response.getEntity().getContentType().getValue());
    }

    private RestHighLevelClient buildClient(ProxyRequestAdapter.ProxyRequest request) {
        URI opensearchAddress = this.datanodeResolver.findByHostname(request.hostname()).map(NodeDto::getTransportAddress).filter(StringUtils::isNotBlank).map(URI::create).orElseThrow(() -> new IllegalStateException("No datanode found matching name " + request.hostname()));
        return this.restClientProvider.buildBasicRestClient(Collections.singletonList(opensearchAddress));
    }
}

