/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.common.collect.ImmutableMap;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.engine.QuerySuggestionsService;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionEntry;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionError;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionFieldType;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionRequest;
import org.graylog.plugins.views.search.engine.suggestions.SuggestionResponse;
import org.graylog.shaded.opensearch2.org.opensearch.OpenSearchException;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.ScriptQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.script.Script;
import org.graylog.shaded.opensearch2.org.opensearch.script.ScriptType;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.ParsedTerms;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.SuggestBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.SuggestBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.term.TermSuggestion;
import org.graylog.shaded.opensearch2.org.opensearch.search.suggest.term.TermSuggestionBuilder;
import org.graylog.storage.errors.ResponseError;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.ParsedOpenSearchException;
import org.graylog.storage.opensearch2.TimeRangeQueryFactory;

public class QuerySuggestionsOS2
implements QuerySuggestionsService {
    private final OpenSearchClient client;
    private final IndexLookup indexLookup;

    @Inject
    public QuerySuggestionsOS2(OpenSearchClient client, IndexLookup indexLookup) {
        this.client = client;
        this.indexLookup = indexLookup;
    }

    public SuggestionResponse suggest(SuggestionRequest req) {
        Set affectedIndices = this.indexLookup.indexNamesForStreamsInTimeRange((Collection)req.streams(), req.timerange());
        TermSuggestionBuilder suggestionBuilder = (TermSuggestionBuilder)((TermSuggestionBuilder)SuggestBuilders.termSuggestion(req.field()).text(req.input())).size(req.size());
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter(QueryBuilders.termsQuery("streams", req.streams())).filter(TimeRangeQueryFactory.create(req.timerange())).filter(QueryBuilders.existsQuery(req.field())).filter(this.getPrefixQuery(req));
        SearchSourceBuilder search = new SearchSourceBuilder().query(query).size(0).aggregation(((TermsAggregationBuilder)AggregationBuilders.terms("fieldvalues").field(req.field())).size(req.size())).suggest(new SuggestBuilder().addSuggestion("corrections", suggestionBuilder));
        try {
            SearchResponse result = this.client.search(new SearchRequest(affectedIndices.toArray(new String[0])).source(search).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN), "Failed to execute aggregation");
            ParsedTerms fieldValues = (ParsedTerms)result.getAggregations().get("fieldvalues");
            List entries = fieldValues.getBuckets().stream().map(b -> new SuggestionEntry(b.getKeyAsString(), b.getDocCount())).collect(Collectors.toList());
            if (!entries.isEmpty()) {
                return SuggestionResponse.forSuggestions((String)req.field(), (String)req.input(), entries, (Long)fieldValues.getSumOfOtherDocCounts());
            }
            TermSuggestion suggestion = (TermSuggestion)result.getSuggest().getSuggestion("corrections");
            List corrections = suggestion.getEntries().stream().flatMap(e -> e.getOptions().stream()).map(o -> new SuggestionEntry(o.getText().string(), (long)o.getFreq())).collect(Collectors.toList());
            return SuggestionResponse.forSuggestions((String)req.field(), (String)req.input(), corrections, null);
        }
        catch (OpenSearchException exception) {
            SuggestionError err = this.tryResponseException(exception).orElseGet(() -> this.parseException(exception));
            return SuggestionResponse.forError((String)req.field(), (String)req.input(), (SuggestionError)err);
        }
    }

    private QueryBuilder getPrefixQuery(SuggestionRequest req) {
        return switch (req.fieldType()) {
            case SuggestionFieldType.TEXTUAL -> QueryBuilders.prefixQuery(req.field(), req.input());
            default -> QuerySuggestionsOS2.getScriptedPrefixQuery(req);
        };
    }

    private static ScriptQueryBuilder getScriptedPrefixQuery(SuggestionRequest req) {
        Script script = new Script(ScriptType.INLINE, "painless", "String val = doc[params.field].value.toString(); return val.startsWith(params.input);", (Map<String, Object>)ImmutableMap.of((Object)"field", (Object)req.field(), (Object)"input", (Object)req.input()));
        return QueryBuilders.scriptQuery(script);
    }

    private Optional<SuggestionError> tryResponseException(OpenSearchException exception) {
        return this.client.parseResponseException(exception).map(ResponseError::error).flatMap(e -> e.rootCause().stream().findFirst()).map(e -> SuggestionError.create((String)e.type(), (String)e.reason()));
    }

    private SuggestionError parseException(OpenSearchException exception) {
        Throwable cause = this.getCause(exception);
        try {
            ParsedOpenSearchException parsed = ParsedOpenSearchException.from(cause.toString());
            return SuggestionError.create((String)parsed.type(), (String)parsed.reason());
        }
        catch (IllegalArgumentException iae) {
            return SuggestionError.create((String)"Aggregation error", (String)cause.getMessage());
        }
    }

    private Throwable getCause(Throwable exception) {
        if (exception.getCause() != null) {
            return this.getCause(exception.getCause());
        }
        return exception;
    }
}

