/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import jakarta.annotation.Nonnull;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.Automaton;
import org.graylog.shaded.opensearch2.org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.graylog.shaded.opensearch2.org.opensearch.common.regex.Regex;

public class RemoteReindexAllowlist {
    private final URI remoteHost;
    private final String rawValue;
    private final List<String> parsedValue;

    public RemoteReindexAllowlist(URI remoteHost, String requestedAllowlist) {
        this.remoteHost = remoteHost;
        this.rawValue = requestedAllowlist;
        this.parsedValue = RemoteReindexAllowlist.parse(remoteHost, requestedAllowlist);
    }

    private static List<String> parse(URI remoteHost, String rawValue) {
        if (rawValue == null || rawValue.isBlank()) {
            return Collections.singletonList(RemoteReindexAllowlist.fixProtocolPrefix(remoteHost.toString(), remoteHost));
        }
        return Arrays.stream(rawValue.split(",")).map(String::trim).map(allowlistItem -> RemoteReindexAllowlist.fixProtocolPrefix(allowlistItem, remoteHost)).toList();
    }

    public void validate() {
        String[] patterns = this.value().toArray(new String[0]);
        Automaton automaton = Regex.simpleMatchToAutomaton(patterns);
        CharacterRunAutomaton characterRunAutomaton = new CharacterRunAutomaton(automaton);
        boolean isHostMatching = characterRunAutomaton.run(this.remoteHost.getHost() + ":" + this.remoteHost.getPort());
        if (!isHostMatching) {
            throw new IllegalArgumentException("Provided allowlist[" + this.rawValue + "] doesn't match remote host address[" + String.valueOf(this.remoteHost) + "]");
        }
    }

    @Nonnull
    public List<String> value() {
        return this.parsedValue;
    }

    private static String fixProtocolPrefix(String allowlistItem, URI remoteHost) {
        if (remoteHost.toString().equals(allowlistItem)) {
            return allowlistItem.replaceAll("https?://", "");
        }
        return allowlistItem;
    }

    public boolean isClusterSettingMatching(String clusterAllowlistSetting) {
        List<String> requested = this.value();
        Set<String> existing = RemoteReindexAllowlist.parseClusterConfigValue(clusterAllowlistSetting);
        return existing.containsAll(requested) && existing.size() == requested.size();
    }

    @Nonnull
    private static Set<String> parseClusterConfigValue(String clusterAllowlistSetting) {
        return Optional.ofNullable(clusterAllowlistSetting).map(String::trim).map(v -> StringUtils.removeStart((String)v, (String)"[")).map(v -> StringUtils.removeEnd((String)v, (String)"]")).map(v -> v.split(",")).stream().flatMap(Arrays::stream).map(String::trim).collect(Collectors.toSet());
    }
}

