/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.common.base.Suppliers;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Provider;
import jakarta.inject.Singleton;
import java.net.URI;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.graylog.shaded.opensearch2.org.apache.http.HttpHost;
import org.graylog.shaded.opensearch2.org.apache.http.HttpRequestInterceptor;
import org.graylog.shaded.opensearch2.org.apache.http.client.CredentialsProvider;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestClientBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestHighLevelClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.NodesSniffer;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.Sniffer;
import org.graylog.storage.opensearch2.OpenSearchFilterDeprecationWarningsInterceptor;
import org.graylog.storage.opensearch2.sniffer.SnifferAggregator;
import org.graylog.storage.opensearch2.sniffer.SnifferBuilder;
import org.graylog.storage.opensearch2.sniffer.SnifferFilter;
import org.graylog2.configuration.ElasticsearchClientConfiguration;
import org.graylog2.configuration.IndexerHosts;
import org.graylog2.security.TrustManagerAndSocketFactoryProvider;
import org.graylog2.security.jwt.IndexerJwtAuthToken;
import org.graylog2.system.shutdown.GracefulShutdownService;

@Singleton
public class RestClientProvider
implements Provider<RestHighLevelClient> {
    private final Supplier<RestHighLevelClient> clientSupplier;
    private final GracefulShutdownService shutdownService;
    private final ElasticsearchClientConfiguration configuration;
    private final CredentialsProvider credentialsProvider;
    private final TrustManagerAndSocketFactoryProvider trustManagerAndSocketFactoryProvider;
    private final IndexerJwtAuthToken indexerJwtAuthToken;
    private final Set<SnifferBuilder> snifferBuilders;
    private final Set<SnifferFilter> snifferFilters;

    @Inject
    public RestClientProvider(GracefulShutdownService shutdownService, @IndexerHosts List<URI> hosts, ElasticsearchClientConfiguration configuration, CredentialsProvider credentialsProvider, TrustManagerAndSocketFactoryProvider trustManagerAndSocketFactoryProvider, IndexerJwtAuthToken indexerJwtAuthToken, Set<SnifferBuilder> snifferBuilders, Set<SnifferFilter> snifferFilters) {
        this.shutdownService = shutdownService;
        this.configuration = configuration;
        this.credentialsProvider = credentialsProvider;
        this.trustManagerAndSocketFactoryProvider = trustManagerAndSocketFactoryProvider;
        this.indexerJwtAuthToken = indexerJwtAuthToken;
        this.clientSupplier = Suppliers.memoize(() -> this.createClient(hosts));
        this.snifferBuilders = snifferBuilders;
        this.snifferFilters = snifferFilters;
    }

    @Nonnull
    private RestHighLevelClient createClient(List<URI> hosts) {
        RestHighLevelClient client = this.buildBasicRestClient(hosts);
        this.registerSniffers(client);
        return client;
    }

    private void registerSniffers(RestHighLevelClient client) {
        List<NodesSniffer> sniffers = this.snifferBuilders.stream().filter(SnifferBuilder::enabled).map(b -> b.create(client.getLowLevelClient())).toList();
        if (!sniffers.isEmpty()) {
            List<SnifferFilter> filters = this.snifferFilters.stream().filter(SnifferFilter::enabled).toList();
            SnifferAggregator snifferAggregator = new SnifferAggregator(sniffers, filters);
            Sniffer sniffer = Sniffer.builder(client.getLowLevelClient()).setSniffIntervalMillis(Math.toIntExact(this.configuration.discoveryFrequency().toMilliseconds())).setNodesSniffer(snifferAggregator).build();
            this.shutdownService.register(sniffer::close);
        }
    }

    public RestHighLevelClient get() {
        return this.clientSupplier.get();
    }

    public RestHighLevelClient buildBasicRestClient(List<URI> hosts) {
        HttpHost[] esHosts = (HttpHost[])hosts.stream().map(uri -> new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme())).toArray(HttpHost[]::new);
        RestClientBuilder restClientBuilder = RestClient.builder(esHosts).setRequestConfigCallback(requestConfig -> {
            requestConfig.setConnectTimeout(Math.toIntExact(this.configuration.elasticsearchConnectTimeout().toMilliseconds())).setSocketTimeout(Math.toIntExact(this.configuration.elasticsearchSocketTimeout().toMilliseconds())).setExpectContinueEnabled(this.configuration.useExpectContinue());
            if (!this.indexerJwtAuthToken.isJwtAuthEnabled()) {
                requestConfig.setAuthenticationEnabled(true);
            }
            return requestConfig;
        }).setHttpClientConfigCallback(httpClientConfig -> {
            httpClientConfig.setMaxConnTotal(this.configuration.elasticsearchMaxTotalConnections()).setMaxConnPerRoute(this.configuration.elasticsearchMaxTotalConnectionsPerRoute());
            if (this.indexerJwtAuthToken.isJwtAuthEnabled()) {
                httpClientConfig.addInterceptorLast(this.jwtAuthInterceptor());
            } else {
                httpClientConfig.setDefaultCredentialsProvider(this.credentialsProvider);
            }
            if (this.configuration.muteDeprecationWarnings()) {
                httpClientConfig.addInterceptorFirst(new OpenSearchFilterDeprecationWarningsInterceptor());
            }
            if (hosts.stream().anyMatch(host -> host.getScheme().equalsIgnoreCase("https"))) {
                httpClientConfig.setSSLContext(this.trustManagerAndSocketFactoryProvider.getSslContext());
            }
            return httpClientConfig;
        }).setChunkedEnabled(this.configuration.compressionEnabled());
        return new RestHighLevelClient(restClientBuilder);
    }

    @Nonnull
    private HttpRequestInterceptor jwtAuthInterceptor() {
        return (request, context) -> this.indexerJwtAuthToken.headerValue().ifPresent(value -> request.addHeader("Authorization", (String)value));
    }
}

