/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.graylog.shaded.opensearch2.org.apache.http.HttpEntity;
import org.graylog.shaded.opensearch2.org.apache.http.entity.ContentType;
import org.graylog.shaded.opensearch2.org.apache.http.entity.StringEntity;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.storage.opensearch2.PlainJsonApi;
import org.graylog2.indexer.security.SecurityAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecurityAdapterOS
implements SecurityAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityAdapterOS.class);
    private final PlainJsonApi jsonApi;
    private final ObjectMapper objectMapper;

    @Inject
    public SecurityAdapterOS(ObjectMapper objectMapper, PlainJsonApi jsonApi) {
        this.objectMapper = objectMapper;
        this.jsonApi = jsonApi;
    }

    public SecurityAdapter.Mapping getMappingForRole(String role) {
        JsonNode result = this.jsonApi.perform(this.request("GET", "rolesmapping/" + role), "Unable to retrieve role mapping for role " + role);
        JsonNode fields = result.path(role);
        try {
            return (SecurityAdapter.Mapping)this.objectMapper.treeToValue((TreeNode)fields, SecurityAdapter.Mapping.class);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public SecurityAdapter.MappingResponse addUserToRoleMapping(String role, String user) {
        SecurityAdapter.Mapping mapping = this.getMappingForRole(role);
        if (!mapping.users().contains(user)) {
            ArrayList<String> users = new ArrayList<String>();
            users.addAll(mapping.users());
            users.add(user);
            return this.setUserToRoleMapping(role, new SecurityAdapter.Mapping(mapping.backendRoles(), mapping.hosts(), users));
        }
        return new SecurityAdapter.MappingResponse("OK", "User already in mapping");
    }

    public SecurityAdapter.MappingResponse removeUserFromRoleMapping(String role, String user) {
        SecurityAdapter.Mapping mapping = this.getMappingForRole(role);
        if (mapping.users().contains(user)) {
            List<String> users = mapping.users().stream().filter(u -> !u.equals(user)).toList();
            return this.setUserToRoleMapping(role, new SecurityAdapter.Mapping(mapping.backendRoles(), mapping.hosts(), users));
        }
        return new SecurityAdapter.MappingResponse("OK", "User did not exist in mapping");
    }

    private SecurityAdapter.MappingResponse setUserToRoleMapping(String role, SecurityAdapter.Mapping mapping) {
        try {
            JsonNode result = this.jsonApi.perform(this.request("PUT", "rolesmapping/" + role, new StringEntity(this.objectMapper.writeValueAsString((Object)mapping), ContentType.APPLICATION_JSON)), "Could not set role mapping for role " + role);
            SecurityAdapter.MappingResponse retval = new SecurityAdapter.MappingResponse(result.get("status").asText(), result.get("message").asText());
            return retval;
        }
        catch (JsonProcessingException ex) {
            LOG.error("Could not send Request: {}", (Object)ex.getMessage(), (Object)ex);
            return new SecurityAdapter.MappingResponse("ERROR", ex.getMessage());
        }
    }

    private Request request(String method, String endpoint) {
        return this.request(method, endpoint, null);
    }

    private Request request(String method, String endpoint, HttpEntity entity) {
        Request request = new Request(method, "/_plugins/_security/api/" + endpoint);
        request.addParameter("format", "json");
        if (entity != null) {
            request.setEntity(entity);
        }
        return request;
    }
}

