/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2;

import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.assistedinject.FactoryModuleBuilder;
import com.google.inject.binder.LinkedBindingBuilder;
import com.google.inject.binder.ScopedBindingBuilder;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.OptionalBinder;
import org.graylog.plugins.views.ViewsModule;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.export.ExportBackend;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.OpenSearchBackend;
import org.graylog.storage.opensearch2.views.export.OpenSearchExportBackend;
import org.graylog.storage.opensearch2.views.export.RequestStrategy;
import org.graylog.storage.opensearch2.views.export.SearchAfter;
import org.graylog.storage.opensearch2.views.searchtypes.EventListStrategy;
import org.graylog.storage.opensearch2.views.searchtypes.OSEventListDelegate;
import org.graylog.storage.opensearch2.views.searchtypes.OSMessageList;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivot;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotBucketSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotSeriesSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.buckets.OSDateRangeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.buckets.OSTimeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.buckets.OSValuesHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSAverageHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSCardinalityHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSCountHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSLatestHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSMaxHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSMinHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSPercentageHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSPercentilesHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSStdDevHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSSumHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSSumOfSquaresHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSVarianceHandler;
import org.graylog2.storage.SearchVersion;

public class ViewsOSBackendModule
extends ViewsModule {
    private final SearchVersion supportedSearchVersion;

    public ViewsOSBackendModule(SearchVersion supportedSearchVersion) {
        this.supportedSearchVersion = supportedSearchVersion;
    }

    protected void configure() {
        this.install(new FactoryModuleBuilder().build(OSGeneratedQueryContext.Factory.class));
        this.registerVersionedQueryBackend(this.supportedSearchVersion, OpenSearchBackend.class);
        this.registerOSSearchTypeHandler("messages", OSMessageList.class);
        this.registerOSSearchTypeHandler("events", OSEventListDelegate.class);
        OptionalBinder.newOptionalBinder((Binder)this.binder(), EventListStrategy.class);
        this.registerOSSearchTypeHandler("pivot", OSPivot.class).in(Scopes.SINGLETON);
        this.registerPivotSeriesHandler("avg", OSAverageHandler.class);
        this.registerPivotSeriesHandler("card", OSCardinalityHandler.class);
        this.registerPivotSeriesHandler("count", OSCountHandler.class);
        this.registerPivotSeriesHandler("max", OSMaxHandler.class);
        this.registerPivotSeriesHandler("min", OSMinHandler.class);
        this.registerPivotSeriesHandler("stddev", OSStdDevHandler.class);
        this.registerPivotSeriesHandler("sum", OSSumHandler.class);
        this.registerPivotSeriesHandler("sumofsquares", OSSumOfSquaresHandler.class);
        this.registerPivotSeriesHandler("variance", OSVarianceHandler.class);
        this.registerPivotSeriesHandler("percentage", OSPercentageHandler.class);
        this.registerPivotSeriesHandler("percentile", OSPercentilesHandler.class);
        this.registerPivotSeriesHandler("latest", OSLatestHandler.class);
        this.registerPivotBucketHandler("values", OSValuesHandler.class);
        this.registerPivotBucketHandler("time", OSTimeHandler.class);
        this.registerPivotBucketHandler("date_range", OSDateRangeHandler.class);
        this.bindExportBackend().to(OpenSearchExportBackend.class);
        this.bindRequestStrategy().to(SearchAfter.class);
    }

    private LinkedBindingBuilder<RequestStrategy> bindRequestStrategy() {
        return this.bind(RequestStrategy.class);
    }

    private LinkedBindingBuilder<ExportBackend> bindExportBackend() {
        return this.bindExportBackend(this.supportedSearchVersion);
    }

    private MapBinder<String, OSPivotBucketSpecHandler<? extends BucketSpec>> pivotBucketHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<OSPivotBucketSpecHandler<? extends BucketSpec>>(this){});
    }

    private void registerPivotBucketHandler(String name, Class<? extends OSPivotBucketSpecHandler<? extends BucketSpec>> implementation) {
        this.pivotBucketHandlerBinder().addBinding((Object)name).to(implementation);
    }

    protected MapBinder<String, OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> pivotSeriesHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>>(this){});
    }

    private void registerPivotSeriesHandler(String name, Class<? extends OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> implementation) {
        this.pivotSeriesHandlerBinder().addBinding((Object)name).to(implementation);
    }

    private MapBinder<String, OSSearchTypeHandler<? extends SearchType>> osSearchTypeHandlerBinder() {
        return MapBinder.newMapBinder((Binder)this.binder(), (TypeLiteral)TypeLiteral.get(String.class), (TypeLiteral)new TypeLiteral<OSSearchTypeHandler<? extends SearchType>>(this){});
    }

    private ScopedBindingBuilder registerOSSearchTypeHandler(String name, Class<? extends OSSearchTypeHandler<? extends SearchType>> implementation) {
        return this.osSearchTypeHandlerBinder().addBinding((Object)name).to(implementation);
    }
}

