/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.blocks;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.graylog.shaded.opensearch2.org.opensearch.common.settings.Settings;
import org.graylog2.indexer.indices.blocks.IndicesBlockStatus;

public class BlockSettingsParser {
    static final String BLOCK_SETTINGS_PREFIX = "index.blocks.";

    public static IndicesBlockStatus parseBlockSettings(GetSettingsResponse settingsResponse) {
        return BlockSettingsParser.parseBlockSettings(settingsResponse, Optional.empty());
    }

    public static IndicesBlockStatus parseBlockSettings(GetSettingsResponse settingsResponse, Optional<List<String>> indices) {
        IndicesBlockStatus result = new IndicesBlockStatus();
        Map<String, Settings> indexToSettingsMap = settingsResponse.getIndexToSettings();
        indices.orElse(indexToSettingsMap.keySet().stream().toList()).forEach(index -> {
            Set<String> blockSettingsNames;
            Set blockSettingsSetToTrue;
            Settings blockSettings;
            Settings settings = (Settings)indexToSettingsMap.get(index);
            if (settings != null && !(blockSettings = settings.getByPrefix(BLOCK_SETTINGS_PREFIX)).isEmpty() && !(blockSettingsSetToTrue = (blockSettingsNames = blockSettings.names()).stream().filter(s -> blockSettings.getAsBoolean((String)s, false)).map(s -> BLOCK_SETTINGS_PREFIX + s).collect(Collectors.toSet())).isEmpty()) {
                result.addIndexBlocks(index, blockSettingsSetToTrue);
            }
        });
        return result;
    }
}

