/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.cat;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.cat.AliasSummaryResponse;
import org.graylog.storage.opensearch2.cat.IndexSummaryResponse;
import org.graylog.storage.opensearch2.cat.NodeResponse;
import org.graylog2.indexer.cluster.health.NodeShardAllocation;
import org.graylog2.indexer.indices.ShardsInfo;

public class CatApi {
    private final ObjectMapper objectMapper;
    private final OpenSearchClient client;

    @Inject
    public CatApi(ObjectMapper objectMapper, OpenSearchClient client) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public Map<String, String> aliases() {
        Request request = this.request("GET", "aliases");
        request.addParameter("h", "alias,index");
        List<AliasSummaryResponse> response = this.perform(request, new TypeReference<List<AliasSummaryResponse>>(this){}, "Unable to retrieve aliases");
        return response.stream().collect(Collectors.toMap(AliasSummaryResponse::alias, AliasSummaryResponse::index));
    }

    public List<NodeResponse> nodes() {
        Request request = this.request("GET", "nodes");
        request.addParameter("h", "id,name,role,host,ip,fileDescriptorMax,diskUsed,diskTotal,diskUsedPercent");
        request.addParameter("full_id", "true");
        return this.perform(request, new TypeReference<List<NodeResponse>>(this){}, "Unable to retrieve nodes list");
    }

    public List<IndexSummaryResponse> indices() {
        Request request = this.request("GET", "indices");
        request.addParameter("h", "index,status,health");
        return this.perform(request, new TypeReference<List<IndexSummaryResponse>>(this){}, "Unable to retrieve indices list");
    }

    public Set<String> indices(String index, Collection<String> status, String errorMessage) {
        return this.indices(Collections.singleton(index), status, errorMessage);
    }

    public Set<String> indices(Collection<String> indices, Collection<String> status, String errorMessage) {
        String joinedIndices = String.join((CharSequence)",", indices);
        JsonNode jsonResponse = this.requestIndices(joinedIndices, errorMessage);
        return Streams.stream((Iterator)jsonResponse.elements()).filter(index -> status.isEmpty() || status.contains(index.path("status").asText())).map(index -> index.path("index").asText()).collect(Collectors.toSet());
    }

    public Optional<String> indexState(String indexName, String errorMessage) {
        JsonNode jsonResponse = this.requestIndices(indexName, errorMessage);
        return Streams.stream((Iterator)jsonResponse.elements()).filter(index -> index.path("index").asText().equals(indexName)).map(index -> index.path("status").asText()).findFirst();
    }

    public List<ShardsInfo> getShardsInfo(String indexName) {
        return this.requestShardsInfo(indexName).stream().map(ShardsInfo::create).toList();
    }

    private List<JsonNode> requestShardsInfo(String indexName) {
        Request request = this.request("GET", "shards/" + indexName);
        return this.perform(request, new TypeReference<List<JsonNode>>(this){}, "Unable to retrieve index shards");
    }

    private JsonNode requestIndices(String indexName, String errorMessage) {
        Request request = this.request("GET", "indices/" + indexName);
        request.addParameter("h", "index,status");
        request.addParameter("expand_wildcards", "all");
        request.addParameter("s", "index,status");
        return this.perform(request, new TypeReference<JsonNode>(this){}, errorMessage);
    }

    public List<NodeShardAllocation> getNodeShardAllocations() {
        Request request = this.request("GET", "allocation");
        request.addParameter("h", "node,shards");
        return this.perform(request, new TypeReference<List<NodeShardAllocation>>(this){}, "Unable to retrieve node shard allocation");
    }

    private <R> R perform(Request request, TypeReference<R> responseClass, String errorMessage) {
        return (R)this.client.execute((c, requestOptions) -> {
            request.setOptions((RequestOptions)requestOptions);
            Response response = c.getLowLevelClient().performRequest(request);
            return this.returnType(response, responseClass);
        }, errorMessage);
    }

    private <R> R returnType(Response response, TypeReference<R> responseClass) throws IOException {
        return (R)this.objectMapper.readValue(response.getEntity().getContent(), responseClass);
    }

    private Request request(String method, String endpoint) {
        Request request = new Request(method, "/_cat/" + endpoint);
        request.addParameter("format", "json");
        return request;
    }
}

