/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.client;

import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.graylog.shaded.opensearch2.org.apache.http.auth.AuthScope;
import org.graylog.shaded.opensearch2.org.apache.http.auth.UsernamePasswordCredentials;
import org.graylog.shaded.opensearch2.org.apache.http.client.CredentialsProvider;
import org.graylog.shaded.opensearch2.org.apache.http.impl.client.BasicCredentialsProvider;
import org.graylog2.configuration.IndexerHosts;

public class OSCredentialsProvider
implements Provider<CredentialsProvider> {
    private final List<URI> openSearchHosts;
    private final String defaultUserForDiscoveredNodes;
    private final String defaultPasswordForDiscoveredNodes;
    private final boolean discoveryEnabled;

    @Inject
    public OSCredentialsProvider(@IndexerHosts List<URI> openSearchHosts, @Named(value="elasticsearch_discovery_default_user") @Nullable String defaultUserForDiscoveredNodes, @Named(value="elasticsearch_discovery_default_password") @Nullable String defaultPasswordForDiscoveredNodes, @Named(value="elasticsearch_discovery_enabled") boolean discoveryEnabled) {
        this.openSearchHosts = openSearchHosts;
        this.defaultUserForDiscoveredNodes = defaultUserForDiscoveredNodes;
        this.defaultPasswordForDiscoveredNodes = defaultPasswordForDiscoveredNodes;
        this.discoveryEnabled = discoveryEnabled;
    }

    public CredentialsProvider get() {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        this.openSearchHosts.forEach(hostUri -> {
            Iterator splittedUserInfo;
            if (!Strings.isNullOrEmpty((String)hostUri.getUserInfo()) && (splittedUserInfo = Splitter.on((String)":").split((CharSequence)hostUri.getUserInfo()).iterator()).hasNext()) {
                String username = (String)splittedUserInfo.next();
                String password = splittedUserInfo.hasNext() ? (String)splittedUserInfo.next() : null;
                credentialsProvider.setCredentials(new AuthScope(hostUri.getHost(), hostUri.getPort(), AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), new UsernamePasswordCredentials(username, password));
            }
        });
        if (this.discoveryEnabled && !Strings.isNullOrEmpty((String)this.defaultUserForDiscoveredNodes) && !Strings.isNullOrEmpty((String)this.defaultPasswordForDiscoveredNodes)) {
            credentialsProvider.setCredentials(new AuthScope(AuthScope.ANY_HOST, -1, AuthScope.ANY_REALM, AuthScope.ANY_SCHEME), new UsernamePasswordCredentials(this.defaultUserForDiscoveredNodes, this.defaultPasswordForDiscoveredNodes));
        }
        return credentialsProvider;
    }
}

