/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.ism;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Objects;
import java.util.Optional;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.shaded.opensearch2.org.opensearch.client.ResponseException;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog2.indexer.datastream.policy.IsmPolicy;
import org.graylog2.shared.utilities.StringUtils;

public class IsmApi {
    private final ObjectMapper objectMapper;
    private final OpenSearchClient client;

    @Inject
    public IsmApi(OpenSearchClient client, ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public Optional<IsmPolicy> getPolicy(String policyId) {
        Request request = this.request("GET", "policies/" + policyId, null);
        return this.perform(request, new TypeReference<IsmPolicy>(this){}, "Could not get ism policy");
    }

    public void createPolicy(String policyId, IsmPolicy policy) {
        if (!Objects.isNull(policy.id())) {
            if (!policyId.equals(policy.id())) {
                throw new IllegalArgumentException("Policy id present in policy does not match provided id.");
            }
            policy = new IsmPolicy(policy.policy());
        }
        Request request = this.request("PUT", "policies/" + policyId, policy);
        this.perform(request, new TypeReference<IsmPolicy>(this){}, "Unable to create ism policy");
    }

    public void addPolicyToIndex(String policyId, String index) {
        Request request = this.request("POST", "add/" + index, null);
        request.setJsonEntity(StringUtils.f((String)"{\"policy_id\":\"%s\"}", (Object[])new Object[]{policyId}));
        this.perform(request, new TypeReference<JsonNode>(this){}, "Unable to add policy to index");
    }

    public void removePolicyFromIndex(String index) {
        Request request = this.request("POST", "remove/" + index, null);
        this.perform(request, new TypeReference<JsonNode>(this){}, "Unable to remove policy from index");
    }

    public void deletePolicy(String policyId) {
        Request request = this.request("DELETE", "policies/" + policyId, null);
        this.perform(request, new TypeReference<JsonNode>(this){}, "Unable to delete policy");
    }

    private <R> Optional<R> perform(Request request, TypeReference<R> responseClass, String errorMessage) {
        return this.client.execute((c, requestOptions) -> {
            Response response;
            request.setOptions((RequestOptions)requestOptions);
            try {
                response = c.getLowLevelClient().performRequest(request);
            }
            catch (ResponseException e) {
                if (e.getResponse().getStatusLine().getStatusCode() == 404) {
                    return Optional.empty();
                }
                throw e;
            }
            return Optional.of(this.returnType(response, responseClass));
        }, errorMessage);
    }

    private <R> R returnType(Response response, TypeReference<R> responseClass) throws IOException {
        return (R)this.objectMapper.readValue(response.getEntity().getContent(), responseClass);
    }

    private Request request(String method, String endpoint, Object body) {
        Request request = new Request(method, "/_plugins/_ism/" + endpoint);
        request.addParameter("format", "json");
        try {
            request.setJsonEntity(this.objectMapper.writeValueAsString(body));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        return request;
    }
}

