/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.mapping;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.auto.value.AutoValue;
import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.mapping.AutoValue_FieldMappingApi_FieldMapping;

public class FieldMappingApi {
    private final OpenSearchClient client;

    @Inject
    public FieldMappingApi(OpenSearchClient client) {
        this.client = client;
    }

    public Map<String, FieldMapping> fieldTypes(String index) {
        JsonNode result = this.client.executeRequest(this.request(index), "Unable to retrieve field types of index " + index);
        JsonNode fields = result.path(index).path("mappings").path("properties");
        return Streams.stream((Iterator)fields.fields()).collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            JsonNode entryValue = (JsonNode)entry.getValue();
            String type = entryValue.path("type").asText();
            if ("alias".equals(type)) {
                String aliasPath = entryValue.path("path").asText();
                type = fields.path(aliasPath).path("type").asText();
            }
            return FieldMapping.create(type, entryValue.path("fielddata").asBoolean());
        }));
    }

    private Request request(String index) {
        return new Request("GET", "/" + index + "/_mapping");
    }

    @AutoValue
    public static abstract class FieldMapping {
        public abstract String type();

        public abstract Optional<Boolean> fielddata();

        static FieldMapping create(String type, @Nullable Boolean fielddata) {
            return new AutoValue_FieldMappingApi_FieldMapping(type, Optional.ofNullable(fielddata));
        }
    }
}

