/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.sniffer;

import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.graylog.shaded.opensearch2.org.opensearch.client.Node;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.NodesSniffer;
import org.graylog.storage.opensearch2.sniffer.SnifferFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnifferAggregator
implements NodesSniffer {
    private static final Logger LOG = LoggerFactory.getLogger(SnifferAggregator.class);
    private final List<NodesSniffer> sniffers;
    private final List<SnifferFilter> filters;

    public SnifferAggregator(List<NodesSniffer> sniffers, List<SnifferFilter> filters) {
        this.sniffers = sniffers;
        this.filters = filters;
    }

    @Override
    public List<Node> sniff() throws IOException {
        List<Node> discoveredNodes = this.discoverNodes().stream().filter(SnifferAggregator.distinctByKey(n -> n.getHost().toURI())).collect(Collectors.toCollection(ArrayList::new));
        for (SnifferFilter sniffer : this.filters) {
            discoveredNodes = sniffer.filterNodes(discoveredNodes);
        }
        return discoveredNodes;
    }

    @Nonnull
    private List<Node> discoverNodes() {
        return this.sniffers.stream().flatMap(SnifferAggregator::sniff).toList();
    }

    @Nonnull
    private static Stream<Node> sniff(NodesSniffer sniffer) {
        try {
            return sniffer.sniff().stream();
        }
        catch (IOException e) {
            LOG.warn("Sniffer {} failed to sniff nodes: {}", sniffer.getClass(), (Object)e.getMessage());
            return Stream.empty();
        }
    }

    private static <T> Predicate<T> distinctByKey(Function<? super T, ?> keyExtractor) {
        ConcurrentHashMap.KeySetView seen = ConcurrentHashMap.newKeySet();
        return t -> seen.add(keyExtractor.apply(t));
    }
}

