/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.sniffer.impl;

import jakarta.inject.Inject;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.apache.http.HttpHost;
import org.graylog.shaded.opensearch2.org.opensearch.client.Node;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.NodesSniffer;
import org.graylog.storage.opensearch2.sniffer.SnifferBuilder;
import org.graylog2.cluster.nodes.DataNodeDto;
import org.graylog2.cluster.nodes.DataNodeStatus;
import org.graylog2.cluster.nodes.NodeDto;
import org.graylog2.cluster.nodes.NodeService;
import org.graylog2.configuration.RunsWithDataNode;

public class DatanodesSniffer
implements SnifferBuilder {
    private final NodeService<DataNodeDto> nodeService;
    private final boolean runsWithDataNode;

    @Inject
    public DatanodesSniffer(NodeService<DataNodeDto> nodeService, @RunsWithDataNode boolean runsWithDataNode) {
        this.nodeService = nodeService;
        this.runsWithDataNode = runsWithDataNode;
    }

    @Override
    public boolean enabled() {
        return this.runsWithDataNode;
    }

    @Override
    public NodesSniffer create(RestClient restClient) {
        return () -> this.nodeService.allActive().values().stream().filter(n -> n.getDataNodeStatus() == DataNodeStatus.AVAILABLE).map(NodeDto::getTransportAddress).map(host -> new Node(HttpHost.create(host))).collect(Collectors.toList());
    }
}

