/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.sniffer.impl;

import com.google.common.base.Strings;
import jakarta.inject.Inject;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.client.Node;
import org.graylog.storage.opensearch2.sniffer.SnifferFilter;
import org.graylog2.configuration.ElasticsearchClientConfiguration;

public class NodeAttributesFilter
implements SnifferFilter {
    private final boolean enabled;
    private final Predicate<Node> filter;

    @Inject
    public NodeAttributesFilter(ElasticsearchClientConfiguration configuration) {
        this(configuration.discoveryEnabled(), configuration.discoveryFilter());
    }

    public NodeAttributesFilter(boolean enabled, String filterString) {
        this.enabled = enabled;
        this.filter = NodeAttributesFilter.create(filterString);
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public List<Node> filterNodes(List<Node> nodes) {
        return nodes.stream().filter(this.filter).collect(Collectors.toList());
    }

    static Predicate<Node> create(String filter) {
        String value;
        String attribute;
        if (!Strings.isNullOrEmpty((String)filter)) {
            String[] conditions = filter.split(":");
            if (conditions.length < 2) {
                throw new IllegalArgumentException("Invalid filter specified for ES node discovery: " + filter);
            }
            attribute = conditions[0].trim();
            value = conditions[1].trim();
        } else {
            attribute = null;
            value = null;
        }
        return node -> NodeAttributesFilter.nodeMatchesFilter(node, attribute, value);
    }

    private static boolean nodeMatchesFilter(Node node, String attribute, String value) {
        if (attribute == null || value == null) {
            return true;
        }
        return node.getAttributes().getOrDefault(attribute, Collections.emptyList()).contains(value);
    }
}

