/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.sniffer.impl;

import com.google.common.collect.Sets;
import jakarta.inject.Inject;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.graylog.shaded.opensearch2.org.opensearch.client.Node;
import org.graylog.storage.opensearch2.sniffer.SnifferFilter;
import org.graylog2.configuration.ElasticsearchClientConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeLoggingFilter
implements SnifferFilter {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLoggingFilter.class);
    private final Set<String> savedNodes = new LinkedHashSet<String>();
    private final boolean enabled;

    @Inject
    public NodeLoggingFilter(ElasticsearchClientConfiguration configuration) {
        this.enabled = configuration.isNodeActivityLogger();
    }

    @Override
    public boolean enabled() {
        return this.enabled;
    }

    @Override
    public List<Node> filterNodes(List<Node> nodes) {
        Set currentNodes = nodes.stream().map(n -> n.getHost().toURI()).collect(Collectors.toSet());
        Sets.SetView nodesAdded = Sets.difference(currentNodes, this.savedNodes);
        Sets.SetView nodesDropped = Sets.difference(this.savedNodes, currentNodes);
        if (!nodesAdded.isEmpty()) {
            LOG.info("Added node(s): {}", (Object)nodesAdded);
        }
        if (!nodesDropped.isEmpty()) {
            LOG.info("Dropped node(s): {}", (Object)nodesDropped);
        }
        if (!nodesAdded.isEmpty() || !nodesDropped.isEmpty()) {
            LOG.info("Current node list: {}", currentNodes);
        }
        this.savedNodes.clear();
        this.savedNodes.addAll(currentNodes);
        return nodes;
    }
}

