/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.sniffer.impl;

import jakarta.inject.Inject;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestClient;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.NodesSniffer;
import org.graylog.shaded.opensearch2.org.opensearch.client.sniff.OpenSearchNodesSniffer;
import org.graylog.storage.opensearch2.sniffer.SnifferBuilder;
import org.graylog2.configuration.ElasticsearchClientConfiguration;

public class OpensearchClusterSniffer
implements SnifferBuilder {
    private static final long DISCOVERY_FREQUENCY_MS = TimeUnit.SECONDS.toMillis(5L);
    private final OpenSearchNodesSniffer.Scheme scheme;
    private final ElasticsearchClientConfiguration configuration;

    @Inject
    public OpensearchClusterSniffer(ElasticsearchClientConfiguration configuration) {
        this.scheme = this.mapDefaultScheme(configuration.defaultSchemeForDiscoveredNodes());
        this.configuration = configuration;
    }

    @Override
    public boolean enabled() {
        return this.configuration.discoveryEnabled() || this.configuration.isNodeActivityLogger();
    }

    @Override
    public NodesSniffer create(RestClient restClient) {
        return new OpenSearchNodesSniffer(restClient, DISCOVERY_FREQUENCY_MS, this.scheme);
    }

    private OpenSearchNodesSniffer.Scheme mapDefaultScheme(String defaultSchemeForDiscoveredNodes) {
        return switch (defaultSchemeForDiscoveredNodes.toUpperCase(Locale.ENGLISH)) {
            case "HTTP" -> OpenSearchNodesSniffer.Scheme.HTTP;
            case "HTTPS" -> OpenSearchNodesSniffer.Scheme.HTTPS;
            default -> throw new IllegalArgumentException("Invalid default scheme for discovered OS nodes: " + defaultSchemeForDiscoveredNodes);
        };
    }
}

