/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.stats;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableSet;
import jakarta.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Consumer;
import org.graylog.shaded.opensearch2.org.opensearch.client.Request;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.Response;
import org.graylog.storage.opensearch2.OpenSearchClient;

public class StatsApi {
    private final ObjectMapper objectMapper;
    private final OpenSearchClient client;

    @Inject
    public StatsApi(ObjectMapper objectMapper, OpenSearchClient client) {
        this.objectMapper = objectMapper;
        this.client = client;
    }

    public JsonNode indexStats(String index) {
        return this.stats(index);
    }

    public JsonNode indexStatsWithShardLevel(String index) {
        return this.indexStatsWithShardLevel(Collections.singleton(index)).path(index);
    }

    public JsonNode indexStatsWithShardLevel(Collection<String> indices) {
        JsonNode stats = this.stats(indices, (Request request) -> {
            request.addParameter("level", "shards");
            request.addParameter("ignore_unavailable", "true");
        });
        return stats.path("indices");
    }

    public JsonNode indexStatsWithDocsAndStore(Collection<String> indices) {
        JsonNode stats = this.stats(indices, (Collection<String>)ImmutableSet.of((Object)"store", (Object)"docs"));
        return stats.path("indices");
    }

    public Optional<Long> storeSizes(String index) {
        JsonNode stats = this.stats(Collections.singleton(index), Collections.singleton("store"));
        JsonNode sizeInBytes = stats.path("indices").path(index).path("primaries").path("store").path("size_in_bytes");
        return Optional.of(sizeInBytes).filter(JsonNode::isNumber).map(JsonNode::asLong);
    }

    private JsonNode stats(String index) {
        return this.stats(Collections.singleton(index), Collections.emptySet(), request -> {});
    }

    private JsonNode stats(Collection<String> indices, Collection<String> metrics) {
        return this.stats(indices, metrics, request -> {});
    }

    private JsonNode stats(Collection<String> indices, Consumer<Request> fn) {
        return this.stats(indices, Collections.emptySet(), fn);
    }

    private JsonNode stats(Collection<String> indices, Collection<String> metrics, Consumer<Request> prepareRequest) {
        StringBuilder endpoint = new StringBuilder();
        if (!indices.isEmpty()) {
            String joinedIndices = String.join((CharSequence)",", indices);
            endpoint.append("/");
            endpoint.append(joinedIndices);
        }
        endpoint.append("/_stats");
        if (!metrics.isEmpty()) {
            String joinedMetrics = String.join((CharSequence)",", metrics);
            endpoint.append("/");
            endpoint.append(joinedMetrics);
        }
        Request request = new Request("GET", endpoint.toString());
        prepareRequest.accept(request);
        return this.client.execute((c, requestOptions) -> {
            request.setOptions((RequestOptions)requestOptions);
            Response response = c.getLowLevelClient().performRequest(request);
            return this.objectMapper.readTree(response.getEntity().getContent());
        }, "Unable to retrieve index stats for " + String.join((CharSequence)",", indices));
    }
}

