/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views;

import com.google.common.base.MoreObjects;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.FieldTypesLookup;
import org.graylog.plugins.views.search.engine.GeneratedQueryContext;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.opensearch2.views.OpenSearchBackend;
import org.joda.time.DateTimeZone;

public class OSGeneratedQueryContext
implements GeneratedQueryContext {
    private final OpenSearchBackend openSearchBackend;
    private final Map<String, SearchSourceBuilder> searchTypeQueries;
    private final Map<Object, Object> contextMap;
    private final Set<SearchError> errors;
    private final SearchSourceBuilder ssb;
    private final FieldTypesLookup fieldTypes;
    private final MultiBucketsAggregation.Bucket rowBucket;
    private final DateTimeZone timezone;

    @AssistedInject
    public OSGeneratedQueryContext(@Assisted OpenSearchBackend elasticsearchBackend, @Assisted SearchSourceBuilder ssb, @Assisted Collection<SearchError> validationErrors, @Assisted DateTimeZone timezone, FieldTypesLookup fieldTypes) {
        this.openSearchBackend = elasticsearchBackend;
        this.ssb = ssb;
        this.fieldTypes = fieldTypes;
        this.errors = new HashSet<SearchError>(validationErrors);
        this.timezone = timezone;
        this.rowBucket = null;
        this.contextMap = new HashMap<Object, Object>();
        this.searchTypeQueries = new HashMap<String, SearchSourceBuilder>();
    }

    private OSGeneratedQueryContext(OpenSearchBackend openSearchBackend, SearchSourceBuilder ssb, Set<SearchError> errors, FieldTypesLookup fieldTypes, MultiBucketsAggregation.Bucket rowBucket, Map<String, SearchSourceBuilder> searchTypeQueries, Map<Object, Object> contextMap, DateTimeZone timezone) {
        this.openSearchBackend = openSearchBackend;
        this.ssb = ssb;
        this.errors = errors;
        this.fieldTypes = fieldTypes;
        this.rowBucket = rowBucket;
        this.searchTypeQueries = searchTypeQueries;
        this.contextMap = contextMap;
        this.timezone = timezone;
    }

    public SearchSourceBuilder searchSourceBuilder(SearchType searchType) {
        return this.searchTypeQueries.computeIfAbsent(searchType.id(), ignored -> {
            QueryBuilder queryBuilder = this.generateFilterClause(searchType.filter()).map(filterClause -> new BoolQueryBuilder().must(this.ssb.query()).must((QueryBuilder)filterClause)).orElse(this.ssb.query());
            return this.ssb.shallowCopy().slice(this.ssb.slice()).query(queryBuilder);
        });
    }

    Map<String, SearchSourceBuilder> searchTypeQueries() {
        return this.searchTypeQueries;
    }

    public Optional<String> getSearchTypeQueryString(String id) {
        return Optional.ofNullable(this.searchTypeQueries.get(id)).map(SearchSourceBuilder::toString);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("elasticsearch query", (Object)this.ssb).toString();
    }

    public Map<Object, Object> contextMap() {
        return this.contextMap;
    }

    private Optional<QueryBuilder> generateFilterClause(Filter filter) {
        return this.openSearchBackend.generateFilterClause(filter);
    }

    public String seriesName(SeriesSpec seriesSpec, Pivot pivot) {
        return pivot.id() + "-series-" + seriesSpec.id();
    }

    public Optional<String> fieldType(Set<String> streamIds, String field) {
        return this.fieldTypes.getType(streamIds, field);
    }

    public void addError(SearchError error) {
        this.errors.add(error);
    }

    public Collection<SearchError> errors() {
        return this.errors;
    }

    public OSGeneratedQueryContext withRowBucket(MultiBucketsAggregation.Bucket rowBucket) {
        return new OSGeneratedQueryContext(this.openSearchBackend, this.ssb, this.errors, this.fieldTypes, rowBucket, this.searchTypeQueries, this.contextMap, this.timezone);
    }

    public Optional<MultiBucketsAggregation.Bucket> rowBucket() {
        return Optional.ofNullable(this.rowBucket);
    }

    public DateTimeZone timezone() {
        return this.timezone;
    }

    public static interface Factory {
        public OSGeneratedQueryContext create(OpenSearchBackend var1, SearchSourceBuilder var2, Collection<SearchError> var3, DateTimeZone var4);
    }
}

