/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import jakarta.inject.Provider;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import org.graylog.plugins.views.search.Filter;
import org.graylog.plugins.views.search.GlobalOverride;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.QueryResult;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.elasticsearch.IndexLookup;
import org.graylog.plugins.views.search.engine.BackendQuery;
import org.graylog.plugins.views.search.engine.QueryBackend;
import org.graylog.plugins.views.search.engine.QueryExecutionStats;
import org.graylog.plugins.views.search.engine.monitoring.collection.StatsCollector;
import org.graylog.plugins.views.search.errors.SearchError;
import org.graylog.plugins.views.search.errors.SearchTypeError;
import org.graylog.plugins.views.search.errors.SearchTypeErrorParser;
import org.graylog.plugins.views.search.filter.QueryStringFilter;
import org.graylog.plugins.views.search.searchfilters.db.UsedSearchFiltersToQueryStringsMapper;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.MultiSearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.IndicesOptions;
import org.graylog.shaded.opensearch2.org.opensearch.action.support.PlainActionFuture;
import org.graylog.shaded.opensearch2.org.opensearch.common.unit.TimeValue;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ShardOperationFailedException;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.BoolQueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.TimeRangeQueryFactory;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog2.indexer.ElasticsearchException;
import org.graylog2.indexer.FieldTypeException;
import org.graylog2.indexer.ranges.IndexRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.graylog2.streams.StreamService;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenSearchBackend
implements QueryBackend<OSGeneratedQueryContext> {
    private static final Logger LOG = LoggerFactory.getLogger(OpenSearchBackend.class);
    private final Map<String, Provider<OSSearchTypeHandler<? extends SearchType>>> openSearchSearchTypeHandlers;
    private final OpenSearchClient client;
    private final IndexLookup indexLookup;
    private final OSGeneratedQueryContext.Factory queryContextFactory;
    private final UsedSearchFiltersToQueryStringsMapper usedSearchFiltersToQueryStringsMapper;
    private final boolean allowLeadingWildcard;
    private final StatsCollector<QueryExecutionStats> executionStatsCollector;
    private final StreamService streamService;
    private static final int MAX_MSG_LENGTH = 1024;

    @Inject
    public OpenSearchBackend(Map<String, Provider<OSSearchTypeHandler<? extends SearchType>>> elasticsearchSearchTypeHandlers, OpenSearchClient client, IndexLookup indexLookup, OSGeneratedQueryContext.Factory queryContextFactory, UsedSearchFiltersToQueryStringsMapper usedSearchFiltersToQueryStringsMapper, StatsCollector<QueryExecutionStats> executionStatsCollector, StreamService streamService, @Named(value="allow_leading_wildcard_searches") boolean allowLeadingWildcard) {
        this.openSearchSearchTypeHandlers = elasticsearchSearchTypeHandlers;
        this.client = client;
        this.indexLookup = indexLookup;
        this.queryContextFactory = queryContextFactory;
        this.usedSearchFiltersToQueryStringsMapper = usedSearchFiltersToQueryStringsMapper;
        this.executionStatsCollector = executionStatsCollector;
        this.streamService = streamService;
        this.allowLeadingWildcard = allowLeadingWildcard;
    }

    private QueryBuilder translateQueryString(String queryString) {
        return queryString.isEmpty() || queryString.trim().equals("*") ? QueryBuilders.matchAllQuery() : QueryBuilders.queryStringQuery(queryString).allowLeadingWildcard(this.allowLeadingWildcard);
    }

    public StatsCollector<QueryExecutionStats> getExecutionStatsCollector() {
        return this.executionStatsCollector;
    }

    public OSGeneratedQueryContext generate(Query query, Set<SearchError> validationErrors, DateTimeZone timezone) {
        BackendQuery backendQuery = query.query();
        ImmutableSet searchTypes = query.searchTypes();
        QueryBuilder normalizedRootQuery = this.translateQueryString(backendQuery.queryString());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter(normalizedRootQuery);
        this.usedSearchFiltersToQueryStringsMapper.map((Collection)query.filters()).stream().map(this::translateQueryString).forEach(boolQuery::filter);
        this.generateFilterClause(query.filter()).ifPresent(boolQuery::filter);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query(boolQuery).from(0).size(0).trackTotalHits(true);
        OSGeneratedQueryContext queryContext = this.queryContextFactory.create(this, searchSourceBuilder, validationErrors, timezone);
        searchTypes.stream().filter(searchType -> !this.isSearchTypeWithError(queryContext, searchType.id())).forEach(searchType -> {
            String type = searchType.type();
            Provider<OSSearchTypeHandler<? extends SearchType>> searchTypeHandler = this.openSearchSearchTypeHandlers.get(type);
            if (searchTypeHandler == null) {
                LOG.error("Unknown search type {} for elasticsearch backend, cannot generate query part. Skipping this search type.", (Object)type);
                queryContext.addError((SearchError)new SearchTypeError(query, searchType.id(), "Unknown search type '" + type + "' for elasticsearch backend, cannot generate query"));
                return;
            }
            SearchSourceBuilder searchTypeSourceBuilder = queryContext.searchSourceBuilder((SearchType)searchType);
            Set effectiveStreamIds = query.effectiveStreams(searchType);
            BoolQueryBuilder searchTypeOverrides = QueryBuilders.boolQuery().must(searchTypeSourceBuilder.query()).must(Objects.requireNonNull(TimeRangeQueryFactory.create(query.effectiveTimeRange(searchType)), "Timerange for search type " + searchType.id() + " cannot be found in query or search type."));
            if (effectiveStreamIds.stream().noneMatch(s -> s.startsWith("datastream:"))) {
                searchTypeOverrides.must(QueryBuilders.termsQuery("streams", effectiveStreamIds));
            }
            searchType.query().ifPresent(searchTypeQuery -> {
                QueryBuilder normalizedSearchTypeQuery = this.translateQueryString(searchTypeQuery.queryString());
                searchTypeOverrides.must(normalizedSearchTypeQuery);
            });
            this.usedSearchFiltersToQueryStringsMapper.map((Collection)searchType.filters()).stream().map(this::translateQueryString).forEach(searchTypeOverrides::must);
            searchTypeSourceBuilder.query(searchTypeOverrides);
            ((OSSearchTypeHandler)searchTypeHandler.get()).generateQueryPart(query, (SearchType)searchType, queryContext);
        });
        return queryContext;
    }

    public Optional<QueryBuilder> generateFilterClause(Filter filter) {
        if (filter == null) {
            return Optional.empty();
        }
        switch (filter.type()) {
            case "and": {
                BoolQueryBuilder andBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(this::generateFilterClause).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(andBuilder::must));
                return Optional.of(andBuilder);
            }
            case "or": {
                BoolQueryBuilder orBuilder = QueryBuilders.boolQuery();
                filter.filters().stream().map(this::generateFilterClause).forEach(optQueryBuilder -> optQueryBuilder.ifPresent(orBuilder::should));
                return Optional.of(orBuilder);
            }
            case "stream": {
                return Optional.empty();
            }
            case "query_string": {
                return Optional.of(QueryBuilders.queryStringQuery(((QueryStringFilter)filter).query()));
            }
        }
        return Optional.empty();
    }

    public Set<IndexRange> indexRangesForStreamsInTimeRange(Set<String> streamIds, TimeRange timeRange) {
        return this.indexLookup.indexRangesForStreamsInTimeRange(streamIds, timeRange);
    }

    public Optional<String> streamTitle(String streamId) {
        return Optional.ofNullable(this.streamService.streamTitleFromCache(streamId));
    }

    @WithSpan
    public QueryResult doRun(SearchJob job, Query query, OSGeneratedQueryContext queryContext) {
        if (query.searchTypes().isEmpty()) {
            return QueryResult.builder().query(query).searchTypes(Collections.emptyMap()).errors(new HashSet<SearchError>(queryContext.errors())).build();
        }
        LOG.debug("Running query {} for job {}", (Object)query.id(), (Object)job.getId());
        HashMap resultsMap = Maps.newHashMap();
        Set affectedIndices = this.indexLookup.indexNamesForStreamsInTimeRange((Collection)query.usedStreamIds(), query.timerange());
        Map<String, SearchSourceBuilder> searchTypeQueries = queryContext.searchTypeQueries();
        ArrayList<String> searchTypeIds = new ArrayList<String>(searchTypeQueries.keySet());
        List<SearchRequest> searches = searchTypeIds.stream().map(searchTypeId -> {
            Set<String> affectedIndicesForSearchType = query.searchTypes().stream().filter(s -> s.id().equalsIgnoreCase((String)searchTypeId)).findFirst().flatMap(searchType -> {
                if (searchType.effectiveStreams().isEmpty() && query.globalOverride().flatMap(GlobalOverride::timerange).isEmpty() && searchType.timerange().isEmpty()) {
                    return Optional.empty();
                }
                return Optional.of(this.indexLookup.indexNamesForStreamsInTimeRange((Collection)query.effectiveStreams(searchType), query.effectiveTimeRange(searchType)));
            }).orElse(affectedIndices);
            Set<String> indices = affectedIndicesForSearchType.isEmpty() ? Collections.singleton("") : affectedIndicesForSearchType;
            SearchRequest searchRequest = new SearchRequest().source((SearchSourceBuilder)searchTypeQueries.get(searchTypeId)).indices(indices.toArray(new String[0])).indicesOptions(IndicesOptions.LENIENT_EXPAND_OPEN);
            if (!SearchJob.NO_CANCELLATION.equals(job.getCancelAfterSeconds())) {
                searchRequest.setCancelAfterTimeInterval(new TimeValue(job.getCancelAfterSeconds().intValue(), TimeUnit.SECONDS));
            }
            return searchRequest;
        }).map(request -> request.preference(job.getId())).toList();
        PlainActionFuture<MultiSearchResponse> mSearchFuture = this.client.cancellableMsearch(searches);
        job.setQueryExecutionFuture(query.id(), mSearchFuture);
        List<MultiSearchResponse.Item> results = OpenSearchBackend.getResults(mSearchFuture, searches.size());
        for (SearchType searchType : query.searchTypes()) {
            ElasticsearchException e;
            String searchTypeId2 = searchType.id();
            Provider<OSSearchTypeHandler<? extends SearchType>> handlerProvider = this.openSearchSearchTypeHandlers.get(searchType.type());
            if (handlerProvider == null) {
                LOG.error("Unknown search type '{}', cannot convert query result.", (Object)searchType.type());
                continue;
            }
            if (this.isSearchTypeWithError(queryContext, searchTypeId2)) {
                LOG.error("Failed search type '{}', cannot convert query result, skipping.", (Object)searchType.type());
                continue;
            }
            OSSearchTypeHandler handler = (OSSearchTypeHandler)handlerProvider.get();
            int searchTypeIndex = searchTypeIds.indexOf(searchTypeId2);
            MultiSearchResponse.Item multiSearchResponse = results.get(searchTypeIndex);
            if (multiSearchResponse.isFailure()) {
                e = new ElasticsearchException("Search type returned error: ", (Throwable)multiSearchResponse.getFailure());
                queryContext.addError((SearchError)SearchTypeErrorParser.parse((Query)query, (String)searchTypeId2, (ElasticsearchException)e));
                continue;
            }
            if (this.checkForFailedShards(multiSearchResponse).isPresent()) {
                e = this.checkForFailedShards(multiSearchResponse).get();
                queryContext.addError((SearchError)SearchTypeErrorParser.parse((Query)query, (String)searchTypeId2, (ElasticsearchException)e));
                continue;
            }
            try {
                SearchType.Result searchTypeResult = handler.extractResult(job, query, searchType, multiSearchResponse.getResponse(), queryContext);
                if (searchTypeResult == null) continue;
                resultsMap.put(searchTypeId2, searchTypeResult);
            }
            catch (Exception e2) {
                LOG.warn("Unable to extract results: ", (Throwable)e2);
                queryContext.addError((SearchError)new SearchTypeError(query, searchTypeId2, (Throwable)e2));
            }
        }
        LOG.debug("Query {} ran for job {}", (Object)query.id(), (Object)job.getId());
        return QueryResult.builder().query(query).searchTypes((Map)resultsMap).errors(new HashSet<SearchError>(queryContext.errors())).build();
    }

    @NotNull
    private static List<MultiSearchResponse.Item> getResults(PlainActionFuture<MultiSearchResponse> mSearchFuture, int numSearchTypes) {
        try {
            return Arrays.asList(((MultiSearchResponse)mSearchFuture.get()).getResponses());
        }
        catch (InterruptedException | ExecutionException e) {
            return Collections.nCopies(numSearchTypes, new MultiSearchResponse.Item(null, e));
        }
    }

    private boolean isMaxClauseCountException(Throwable throwable) {
        boolean found = throwable.getMessage().contains("[type=too_many_clauses,");
        if (!found && throwable.getCause() != null) {
            return this.isMaxClauseCountException(throwable.getCause());
        }
        return found;
    }

    private String mapExceptionToErrorMessage(Throwable throwable) {
        if (this.isMaxClauseCountException(throwable)) {
            return "Your query exceeded the maxClauseCount setting of OpenSearch. This is probably due to a custom parameter filled from a lookup table. Please check you query and settings.";
        }
        String msg = throwable.getMessage();
        return msg != null && msg.length() > 1024 ? msg.substring(0, 1024) + "..." : msg;
    }

    private Optional<ElasticsearchException> checkForFailedShards(MultiSearchResponse.Item multiSearchResponse) {
        if (multiSearchResponse.isFailure()) {
            return Optional.of(new ElasticsearchException(multiSearchResponse.getFailureMessage(), (Throwable)multiSearchResponse.getFailure()));
        }
        SearchResponse searchResponse = multiSearchResponse.getResponse();
        if (searchResponse != null && searchResponse.getFailedShards() > 0) {
            List<Throwable> shardFailures = Arrays.stream(searchResponse.getShardFailures()).map(ShardOperationFailedException::getCause).toList();
            List<String> nonNumericFieldErrors = shardFailures.stream().map(Throwable::getMessage).filter(message -> message.contains("Expected numeric type on field")).distinct().toList();
            if (!nonNumericFieldErrors.isEmpty()) {
                return Optional.of(new FieldTypeException("Unable to perform search query: ", nonNumericFieldErrors));
            }
            List<String> errors = shardFailures.stream().map(this::mapExceptionToErrorMessage).distinct().toList();
            return Optional.of(new ElasticsearchException("Unable to perform search query: ", errors));
        }
        return Optional.empty();
    }
}

