/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.export;

import jakarta.inject.Inject;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.graylog.plugins.views.search.export.ExportException;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.client.RequestOptions;
import org.graylog.shaded.opensearch2.org.opensearch.client.RestHighLevelClient;
import org.graylog.shaded.opensearch2.org.opensearch.core.action.ShardOperationFailedException;
import org.graylog.storage.opensearch2.OpenSearchClient;
import org.graylog.storage.opensearch2.ThrowingBiFunction;
import org.graylog2.indexer.ElasticsearchException;

public class ExportClient {
    private final OpenSearchClient client;

    @Inject
    public ExportClient(OpenSearchClient client) {
        this.client = client;
    }

    public SearchResponse search(SearchRequest request, String errorMessage) {
        try {
            SearchResponse response = this.client.search(request, errorMessage);
            if (response.getFailedShards() > 0) {
                List<String> errors = Arrays.stream(response.getShardFailures()).map(ShardOperationFailedException::getCause).map(Throwable::getMessage).distinct().toList();
                throw new ElasticsearchException("Unable to perform export query: ", errors);
            }
            return response;
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }

    private ExportException wrapException(Exception e) {
        return new ExportException("Unable to complete export: ", (Exception)((Object)new ElasticsearchException((Throwable)e)));
    }

    public <R> R execute(ThrowingBiFunction<RestHighLevelClient, RequestOptions, R, IOException> fn, String errorMessage) {
        try {
            return this.client.execute(fn, errorMessage);
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
    }
}

