/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.export;

import com.google.common.collect.Streams;
import jakarta.inject.Inject;
import java.util.List;
import java.util.stream.Collectors;
import org.graylog.plugins.views.search.export.ExportMessagesCommand;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchRequest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.FieldSortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;
import org.graylog.storage.opensearch2.views.export.ExportClient;
import org.graylog.storage.opensearch2.views.export.RequestStrategy;

public class SearchAfter
implements RequestStrategy {
    static final String DEFAULT_TIEBREAKER_FIELD = "gl2_second_sort_field";
    static final String EVENTS_TIEBREAKER_FIELD = "_id";
    private final ExportClient client;
    private Object[] searchAfterValues = null;

    @Inject
    public SearchAfter(ExportClient client) {
        this.client = client;
    }

    @Override
    public List<SearchHit> nextChunk(SearchRequest search, ExportMessagesCommand command) {
        SearchResponse result = this.search(search);
        List<SearchHit> hits = Streams.stream((Iterable)result.getHits()).collect(Collectors.toList());
        this.searchAfterValues = this.lastHitSortFrom(hits);
        return hits;
    }

    private SearchResponse search(SearchRequest search) {
        this.configureSort(search.source());
        return this.client.search(search, "Failed to execute Search After request");
    }

    private void configureSort(SearchSourceBuilder source) {
        source.sort((SortBuilder<?>)SortBuilders.fieldSort("timestamp").order(SortOrder.ASC));
        source.sort(((FieldSortBuilder)SortBuilders.fieldSort(DEFAULT_TIEBREAKER_FIELD).order(SortOrder.ASC)).unmappedType("keyword"));
    }

    private Object[] lastHitSortFrom(List<SearchHit> hits) {
        if (hits.isEmpty()) {
            return null;
        }
        SearchHit lastHit = hits.get(hits.size() - 1);
        return lastHit.getSortValues();
    }

    @Override
    public SearchSourceBuilder configure(SearchSourceBuilder ssb) {
        return this.searchAfterValues == null ? ssb : ssb.searchAfter(this.searchAfterValues);
    }
}

