/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.searchtypes.pivot;

import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.Max;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.Min;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.graylog2.plugin.indexer.searches.timeranges.RelativeRange;
import org.graylog2.plugin.indexer.searches.timeranges.TimeRange;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class EffectiveTimeRangeExtractor {
    AbsoluteRange extract(SearchResponse queryResult, Query query, Pivot pivot) {
        if (queryResult.getHits().getTotalHits().value != 0L) {
            return this.getAbsoluteRangeFromAggregations(queryResult, query, pivot);
        }
        return this.getAbsoluteRangeFromPivot(query, pivot);
    }

    private AbsoluteRange getAbsoluteRangeFromPivot(Query query, Pivot pivot) {
        TimeRange pivotRange = query.effectiveTimeRange((SearchType)pivot);
        return AbsoluteRange.create((DateTime)pivotRange.getFrom(), (DateTime)pivotRange.getTo());
    }

    private AbsoluteRange getAbsoluteRangeFromAggregations(SearchResponse queryResult, Query query, Pivot pivot) {
        Min min = (Min)queryResult.getAggregations().get("timestamp-min");
        Double from = min.getValue();
        Max max = (Max)queryResult.getAggregations().get("timestamp-max");
        Double to = max.getValue();
        TimeRange pivotRange = query.effectiveTimeRange((SearchType)pivot);
        return AbsoluteRange.create((DateTime)(this.isAllMessagesTimeRange(pivotRange) && from != 0.0 ? new DateTime(from.longValue(), DateTimeZone.UTC) : pivotRange.getFrom()), (DateTime)(this.isAllMessagesTimeRange(pivotRange) && to != 0.0 ? new DateTime(to.longValue(), DateTimeZone.UTC) : pivotRange.getTo()));
    }

    private boolean isAllMessagesTimeRange(TimeRange timeRange) {
        RelativeRange relativeRange;
        return timeRange instanceof RelativeRange && (relativeRange = (RelativeRange)timeRange).isAllMessages();
    }
}

