/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.searchtypes.pivot;

import com.google.common.collect.ImmutableList;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import jakarta.inject.Inject;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.graylog.plugins.views.search.Query;
import org.graylog.plugins.views.search.SearchJob;
import org.graylog.plugins.views.search.SearchType;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.BucketSpecHandler;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotResult;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.HasAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.MaxAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.MinAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.builder.SearchSourceBuilder;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.AggTypes;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.EffectiveTimeRangeExtractor;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.InitialBucket;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotBucketSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotSeriesSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.PivotBucket;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.Placement;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.SeriesAggregationBuilder;
import org.graylog2.plugin.indexer.searches.timeranges.AbsoluteRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSPivot
implements OSSearchTypeHandler<Pivot> {
    private static final Logger LOG = LoggerFactory.getLogger(OSPivot.class);
    private static final String AGG_NAME = "agg";
    private final Map<String, OSPivotBucketSpecHandler<? extends BucketSpec>> bucketHandlers;
    private final Map<String, OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> seriesHandlers;
    private final EffectiveTimeRangeExtractor effectiveTimeRangeExtractor;

    @Inject
    public OSPivot(Map<String, OSPivotBucketSpecHandler<? extends BucketSpec>> bucketHandlers, Map<String, OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation>> seriesHandlers, EffectiveTimeRangeExtractor effectiveTimeRangeExtractor) {
        this.bucketHandlers = bucketHandlers;
        this.seriesHandlers = seriesHandlers;
        this.effectiveTimeRangeExtractor = effectiveTimeRangeExtractor;
    }

    public void doGenerateQueryPart(Query query, Pivot pivot, OSGeneratedQueryContext queryContext) {
        boolean generateRollups;
        LOG.debug("Generating aggregation for {}", (Object)pivot);
        SearchSourceBuilder searchSourceBuilder = queryContext.searchSourceBuilder((SearchType)pivot);
        Map<Object, Object> contextMap = queryContext.contextMap();
        AggTypes aggTypes = new AggTypes();
        contextMap.put(pivot.id(), aggTypes);
        boolean bl = generateRollups = pivot.rollup() || pivot.rowGroups().isEmpty() && pivot.columnGroups().isEmpty();
        if (generateRollups) {
            this.seriesStream(pivot, queryContext, "global rollup").filter(result -> Placement.METRIC.equals((Object)result.placement())).map(SeriesAggregationBuilder::aggregationBuilder).forEach(searchSourceBuilder::aggregation);
        }
        BucketSpecHandler.CreatedAggregations<AggregationBuilder> createdAggregations = this.createPivots(BucketSpecHandler.Direction.Row, query, pivot, pivot.rowGroups(), queryContext);
        AggregationBuilder rootAggregation = (AggregationBuilder)createdAggregations.root();
        AggregationBuilder leafAggregation = (AggregationBuilder)createdAggregations.leaf();
        List metrics = createdAggregations.metrics();
        this.seriesStream(pivot, queryContext, "metrics").forEach(result -> {
            switch (result.placement()) {
                case METRIC: {
                    metrics.forEach(metric -> metric.subAggregation(result.aggregationBuilder()));
                    break;
                }
                case ROW: {
                    rootAggregation.subAggregation(result.aggregationBuilder());
                    break;
                }
                case ROOT: {
                    if (generateRollups) break;
                    searchSourceBuilder.aggregation(result.aggregationBuilder());
                }
            }
        });
        if (!pivot.columnGroups().isEmpty()) {
            BucketSpecHandler.CreatedAggregations<AggregationBuilder> columnsAggregation = this.createPivots(BucketSpecHandler.Direction.Column, query, pivot, pivot.columnGroups(), queryContext);
            AggregationBuilder columnsRootAggregation = (AggregationBuilder)columnsAggregation.root();
            AggregationBuilder columnsLeafAggregation = (AggregationBuilder)columnsAggregation.leaf();
            List columnMetrics = columnsAggregation.metrics();
            this.seriesStream(pivot, queryContext, "metrics").forEach(result -> {
                AggregationBuilder aggregationBuilder = result.aggregationBuilder();
                switch (result.placement()) {
                    case COLUMN: {
                        columnsLeafAggregation.subAggregation(aggregationBuilder);
                        break;
                    }
                    case METRIC: {
                        columnMetrics.forEach(metric -> metric.subAggregation(aggregationBuilder));
                    }
                }
            });
            if (leafAggregation != null) {
                leafAggregation.subAggregation(columnsRootAggregation);
            } else {
                searchSourceBuilder.aggregation(columnsRootAggregation);
            }
        }
        if (rootAggregation != null) {
            searchSourceBuilder.aggregation(rootAggregation);
        }
        this.addTimeStampAggregations(searchSourceBuilder);
    }

    private void addTimeStampAggregations(SearchSourceBuilder searchSourceBuilder) {
        MinAggregationBuilder startTimestamp = (MinAggregationBuilder)AggregationBuilders.min("timestamp-min").field("timestamp");
        MaxAggregationBuilder endTimestamp = (MaxAggregationBuilder)AggregationBuilders.max("timestamp-max").field("timestamp");
        searchSourceBuilder.aggregation(startTimestamp);
        searchSourceBuilder.aggregation(endTimestamp);
    }

    private BucketSpecHandler.CreatedAggregations<AggregationBuilder> createPivots(BucketSpecHandler.Direction direction, Query query, Pivot pivot, List<BucketSpec> pivots, OSGeneratedQueryContext queryContext) {
        AggregationBuilder leaf = null;
        AggregationBuilder root = null;
        ArrayList metrics = new ArrayList();
        for (BucketSpec bucketSpec : pivots) {
            OSPivotBucketSpecHandler<? extends BucketSpec> bucketHandler = this.bucketHandlers.get(bucketSpec.type());
            BucketSpecHandler.CreatedAggregations bucketAggregations = bucketHandler.createAggregation(direction, AGG_NAME, pivot, bucketSpec, queryContext, query);
            AggregationBuilder aggregationRoot = (AggregationBuilder)bucketAggregations.root();
            AggregationBuilder aggregationLeaf = (AggregationBuilder)bucketAggregations.leaf();
            List aggregationMetrics = bucketAggregations.metrics();
            metrics.addAll(aggregationMetrics);
            if (root == null && leaf == null) {
                root = aggregationRoot;
                leaf = aggregationLeaf;
                continue;
            }
            leaf.subAggregation(aggregationRoot);
            leaf = aggregationLeaf;
        }
        return BucketSpecHandler.CreatedAggregations.create(root, leaf, metrics);
    }

    private Stream<SeriesAggregationBuilder> seriesStream(Pivot pivot, OSGeneratedQueryContext queryContext, String reason) {
        return pivot.series().stream().distinct().flatMap(seriesSpec -> {
            String seriesName = queryContext.seriesName((SeriesSpec)seriesSpec, pivot);
            LOG.debug("Adding {} series '{}' with name '{}'", new Object[]{reason, seriesSpec.type(), seriesName});
            OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation> esPivotSeriesSpecHandler = this.seriesHandlers.get(seriesSpec.type());
            if (esPivotSeriesSpecHandler == null) {
                throw new IllegalArgumentException("No series handler registered for: " + seriesSpec.type());
            }
            return esPivotSeriesSpecHandler.createAggregation(seriesName, pivot, (SeriesSpec)seriesSpec, this, queryContext).stream();
        });
    }

    @Override
    @WithSpan
    public SearchType.Result doExtractResult(SearchJob job, Query query, Pivot pivot, SearchResponse queryResult, Aggregations aggregations, OSGeneratedQueryContext queryContext) {
        AbsoluteRange effectiveTimerange = this.effectiveTimeRangeExtractor.extract(queryResult, query, pivot);
        Stream fieldsNames = pivot.rowGroups().stream().flatMap(bs -> bs.fields().stream());
        ArrayList seriesNames = pivot.series().stream().map(SeriesSpec::id).toList();
        ArrayList colGroupNames = pivot.columnGroups().isEmpty() ? seriesNames : new ArrayList();
        PivotResult.Builder resultBuilder = PivotResult.builder().id(pivot.id()).effectiveTimerange(effectiveTimerange).total(this.extractDocumentCount(queryResult));
        pivot.name().ifPresent(arg_0 -> ((PivotResult.Builder)resultBuilder).name(arg_0));
        MultiBucketsAggregation.Bucket initialBucket = this.createInitialBucket(queryResult);
        this.retrieveBuckets(pivot, pivot.rowGroups(), initialBucket).forEach(tuple -> {
            ImmutableList<String> rowKeys = tuple.keys();
            MultiBucketsAggregation.Bucket rowBucket = tuple.bucket();
            PivotResult.Row.Builder rowBuilder = PivotResult.Row.builder().key(rowKeys).source("leaf");
            if (pivot.columnGroups().isEmpty() || pivot.rollup()) {
                this.processSeries(rowBuilder, queryResult, queryContext, pivot, new ArrayDeque<String>(), rowBucket, true, "row-leaf");
            }
            if (!pivot.columnGroups().isEmpty()) {
                OSGeneratedQueryContext contextWithRowBucket = queryContext.withRowBucket(rowBucket);
                this.retrieveBuckets(pivot, pivot.columnGroups(), rowBucket).forEach(columnBucketTuple -> {
                    ImmutableList<String> columnKeys = columnBucketTuple.keys();
                    colGroupNames.add(String.join((CharSequence)", ", Stream.concat(columnKeys.stream(), seriesNames.stream()).toList()));
                    MultiBucketsAggregation.Bucket columnBucket = columnBucketTuple.bucket();
                    this.processSeries(rowBuilder, queryResult, contextWithRowBucket, pivot, new ArrayDeque<String>((Collection<String>)columnKeys), columnBucket, false, "col-leaf");
                });
            }
            resultBuilder.addRow(rowBuilder.build());
        });
        if (!pivot.rowGroups().isEmpty() && pivot.rollup()) {
            PivotResult.Row.Builder rowBuilder = PivotResult.Row.builder().key(ImmutableList.of());
            this.processSeries(rowBuilder, queryResult, queryContext, pivot, new ArrayDeque<String>(), initialBucket, true, "row-inner");
            resultBuilder.addRow(rowBuilder.source("non-leaf").build());
        }
        return resultBuilder.columnNames(Stream.concat(fieldsNames, colGroupNames.stream().distinct().sorted()).toList()).build();
    }

    private Stream<PivotBucket> retrieveBuckets(Pivot pivot, List<BucketSpec> pivots, MultiBucketsAggregation.Bucket initialBucket) {
        Stream<PivotBucket> result = Stream.of(PivotBucket.create((ImmutableList<String>)ImmutableList.of(), initialBucket));
        for (BucketSpec bucketSpec : pivots) {
            result = result.flatMap(tuple -> {
                OSPivotBucketSpecHandler<? extends BucketSpec> bucketHandler = this.bucketHandlers.get(bucketSpec.type());
                return bucketHandler.extractBuckets(pivot, bucketSpec, (PivotBucket)tuple);
            });
        }
        return result;
    }

    private MultiBucketsAggregation.Bucket createInitialBucket(SearchResponse queryResult) {
        return InitialBucket.create(queryResult);
    }

    private void processSeries(PivotResult.Row.Builder rowBuilder, SearchResponse searchResult, OSGeneratedQueryContext queryContext, Pivot pivot, ArrayDeque<String> columnKeys, HasAggregations aggregation, boolean rollup, String source) {
        pivot.series().forEach(seriesSpec -> {
            OSPivotSeriesSpecHandler<? extends SeriesSpec, ? extends Aggregation> seriesHandler = this.seriesHandlers.get(seriesSpec.type());
            Aggregation series = seriesHandler.extractAggregationFromResult(pivot, (PivotSpec)seriesSpec, aggregation, queryContext);
            seriesHandler.handleResult(pivot, (SeriesSpec)seriesSpec, searchResult, series, this, queryContext).map(value -> {
                columnKeys.addLast(value.id());
                PivotResult.Value v = PivotResult.Value.create((Collection)columnKeys, (Object)value.value(), (boolean)rollup, (String)source);
                columnKeys.removeLast();
                return v;
            }).forEach(arg_0 -> ((PivotResult.Row.Builder)rowBuilder).addValue(arg_0));
        });
    }

    private long extractDocumentCount(SearchResponse queryResult) {
        return queryResult.getHits().getTotalHits().value;
    }
}

