/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.searchtypes.pivot.series;

import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Average;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.Avg;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.AvgAggregationBuilder;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotSeriesSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.SeriesAggregationBuilder;

public class OSAverageHandler
extends OSPivotSeriesSpecHandler<Average, Avg> {
    @Nonnull
    public List<SeriesAggregationBuilder> doCreateAggregation(String name, Pivot pivot, Average avgSpec, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext queryContext) {
        AvgAggregationBuilder avg = (AvgAggregationBuilder)AggregationBuilders.avg(name).field(avgSpec.field());
        this.record(queryContext, pivot, (PivotSpec)avgSpec, name, Avg.class);
        return List.of(SeriesAggregationBuilder.metric(avg));
    }

    @Override
    public Stream<OSPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Average pivotSpec, SearchResponse searchResult, Avg avgAggregation, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext OSGeneratedQueryContext2) {
        double value = avgAggregation.getValue();
        if (pivotSpec.wholeNumber().booleanValue()) {
            value = Double.isNaN(value) || Double.isInfinite(value) ? 0.0 : (double)Math.round(value);
        }
        return Stream.of(OSPivotSeriesSpecHandler.Value.create(pivotSpec.id(), "avg", value));
    }
}

