/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.searchtypes.pivot.series;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.HasAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.missing.Missing;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ValueCount;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ValueCountAggregationBuilder;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotSeriesSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.SeriesAggregationBuilder;
import org.jooq.lambda.tuple.Tuple2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSCountHandler
extends OSPivotSeriesSpecHandler<Count, ValueCount> {
    private static final Logger LOG = LoggerFactory.getLogger(OSCountHandler.class);

    @Nonnull
    public List<SeriesAggregationBuilder> doCreateAggregation(String name, Pivot pivot, Count count, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext queryContext) {
        return count.field().map(field -> {
            ValueCountAggregationBuilder value = (ValueCountAggregationBuilder)AggregationBuilders.count(name).field((String)field);
            this.record(queryContext, pivot, (PivotSpec)count, name, ValueCount.class);
            return List.of(SeriesAggregationBuilder.metric(value));
        }).orElse(List.of());
    }

    @Override
    public Stream<OSPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Count count, SearchResponse searchResult, ValueCount valueCount, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext esGeneratedQueryContext) {
        Number value;
        if (valueCount == null) {
            LOG.error("Unexpected null aggregation result, returning 0 for the count. This is a bug.");
            value = 0;
        } else {
            value = valueCount instanceof MultiBucketsAggregation.Bucket ? Long.valueOf(((MultiBucketsAggregation.Bucket)((Object)valueCount)).getDocCount()) : (valueCount instanceof Aggregations ? Long.valueOf(searchResult.getHits().getTotalHits().value) : Long.valueOf(valueCount.getValue()));
        }
        return Stream.of(OSPivotSeriesSpecHandler.Value.create(count.id(), "count", value));
    }

    @Override
    public Aggregation extractAggregationFromResult(Pivot pivot, PivotSpec spec, HasAggregations aggregations, OSGeneratedQueryContext queryContext) {
        Tuple2<String, Class<? extends Aggregation>> objects = this.aggTypes(queryContext, pivot).getTypes(spec);
        if (objects == null) {
            if (aggregations instanceof MultiBucketsAggregation.Bucket) {
                return this.createValueCount(((MultiBucketsAggregation.Bucket)aggregations).getDocCount());
            }
            if (aggregations instanceof Missing) {
                return this.createValueCount(((Missing)aggregations).getDocCount());
            }
        } else {
            return aggregations.getAggregations().get((String)objects.v1);
        }
        return null;
    }

    private Aggregation createValueCount(final Long docCount) {
        return new ValueCount(){

            @Override
            public long getValue() {
                return docCount;
            }

            @Override
            public double value() {
                return docCount.longValue();
            }

            @Override
            public String getValueAsString() {
                return docCount.toString();
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public Map<String, Object> getMetadata() {
                return null;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) throws IOException {
                return null;
            }
        };
    }
}

