/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.searchtypes.pivot.series;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Latest;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.index.query.QueryBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHit;
import org.graylog.shaded.opensearch2.org.opensearch.search.SearchHits;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.AggregationBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.filter.ParsedFilter;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.TopHits;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortBuilders;
import org.graylog.shaded.opensearch2.org.opensearch.search.sort.SortOrder;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotSeriesSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.SeriesAggregationBuilder;

public class OSLatestHandler
extends OSPivotSeriesSpecHandler<Latest, ParsedFilter> {
    private static final String AGG_NAME = "latest_aggregation";

    @Nonnull
    public List<SeriesAggregationBuilder> doCreateAggregation(String name, Pivot pivot, Latest latestSpec, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext queryContext) {
        FilterAggregationBuilder latest = (FilterAggregationBuilder)AggregationBuilders.filter(name, QueryBuilders.existsQuery(latestSpec.field())).subAggregation(AggregationBuilders.topHits(AGG_NAME).size(1).fetchSource(latestSpec.field(), null).sort((SortBuilder<?>)SortBuilders.fieldSort("timestamp").order(SortOrder.DESC)));
        this.record(queryContext, pivot, (PivotSpec)latestSpec, name, ParsedFilter.class);
        return List.of(SeriesAggregationBuilder.metric(latest));
    }

    @Override
    public Stream<OSPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Latest pivotSpec, SearchResponse searchResult, ParsedFilter filterAggregation, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext OSGeneratedQueryContext2) {
        TopHits latestAggregation = (TopHits)filterAggregation.getAggregations().get(AGG_NAME);
        Optional<OSPivotSeriesSpecHandler.Value> latestValue = Optional.ofNullable(latestAggregation).map(TopHits::getHits).map(SearchHits::getHits).filter(hits -> ((SearchHit[])hits).length > 0).map(hits -> hits[0]).map(SearchHit::getSourceAsMap).map(source -> source.get(pivotSpec.field())).map(value -> OSPivotSeriesSpecHandler.Value.create(pivotSpec.id(), "latest", value));
        return latestValue.stream();
    }
}

