/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.storage.opensearch2.views.searchtypes.pivot.series;

import jakarta.inject.Inject;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.graylog.plugins.views.search.searchtypes.pivot.Pivot;
import org.graylog.plugins.views.search.searchtypes.pivot.PivotSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.SeriesSpec;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Count;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Percentage;
import org.graylog.plugins.views.search.searchtypes.pivot.series.Sum;
import org.graylog.shaded.opensearch2.org.opensearch.action.search.SearchResponse;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.ToXContent;
import org.graylog.shaded.opensearch2.org.opensearch.core.xcontent.XContentBuilder;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.Aggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.HasAggregations;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ParsedSum;
import org.graylog.shaded.opensearch2.org.opensearch.search.aggregations.metrics.ValueCount;
import org.graylog.storage.opensearch2.views.OSGeneratedQueryContext;
import org.graylog.storage.opensearch2.views.searchtypes.OSSearchTypeHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.InitialBucket;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.OSPivotSeriesSpecHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.SeriesAggregationBuilder;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSCountHandler;
import org.graylog.storage.opensearch2.views.searchtypes.pivot.series.OSSumHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OSPercentageHandler
extends OSPivotSeriesSpecHandler<Percentage, ValueCount> {
    private static final Logger LOG = LoggerFactory.getLogger(OSCountHandler.class);
    private final OSCountHandler osCountHandler;
    private final OSSumHandler osSumHandler;

    @Inject
    public OSPercentageHandler(OSCountHandler osCountHandler, OSSumHandler osSumHandler) {
        this.osCountHandler = osCountHandler;
        this.osSumHandler = osSumHandler;
    }

    @Nonnull
    public List<SeriesAggregationBuilder> doCreateAggregation(String name, Pivot pivot, Percentage percentage, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext queryContext) {
        List<SeriesAggregationBuilder> aggregation = this.createNestedSeriesAggregation(name, pivot, percentage, searchTypeHandler, queryContext);
        return Stream.concat(aggregation.stream(), aggregation.stream().map(r -> SeriesAggregationBuilder.root(r.aggregationBuilder()))).toList();
    }

    private List<SeriesAggregationBuilder> createNestedSeriesAggregation(String name, Pivot pivot, Percentage percentage, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext queryContext) {
        return switch (percentage.strategy().orElse(Percentage.Strategy.COUNT)) {
            default -> throw new MatchException(null, null);
            case Percentage.Strategy.SUM -> {
                Sum.Builder seriesSpecBuilder = Sum.builder().id(percentage.id());
                Sum seriesSpec = percentage.field().map(arg_0 -> ((Sum.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.osSumHandler.createAggregation(name, pivot, (SeriesSpec)seriesSpec, searchTypeHandler, queryContext);
            }
            case Percentage.Strategy.COUNT -> {
                Count.Builder seriesSpecBuilder = Count.builder().id(percentage.id());
                Count seriesSpec = percentage.field().map(arg_0 -> ((Count.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.osCountHandler.createAggregation(name, pivot, (SeriesSpec)seriesSpec, searchTypeHandler, queryContext);
            }
        };
    }

    private Stream<OSPivotSeriesSpecHandler.Value> handleNestedSeriesResults(Pivot pivot, Percentage percentage, SearchResponse searchResult, Object seriesResult, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext esGeneratedQueryContext) {
        return switch (percentage.strategy().orElse(Percentage.Strategy.COUNT)) {
            default -> throw new MatchException(null, null);
            case Percentage.Strategy.SUM -> {
                Sum.Builder seriesSpecBuilder = Sum.builder().id(percentage.id());
                Sum seriesSpec = percentage.field().map(arg_0 -> ((Sum.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.osSumHandler.handleResult(pivot, (SeriesSpec)seriesSpec, searchResult, seriesResult, searchTypeHandler, esGeneratedQueryContext);
            }
            case Percentage.Strategy.COUNT -> {
                Count.Builder seriesSpecBuilder = Count.builder().id(percentage.id());
                Count seriesSpec = percentage.field().map(arg_0 -> ((Count.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.osCountHandler.handleResult(pivot, (SeriesSpec)seriesSpec, searchResult, seriesResult, searchTypeHandler, esGeneratedQueryContext);
            }
        };
    }

    @Override
    public Stream<OSPivotSeriesSpecHandler.Value> doHandleResult(Pivot pivot, Percentage percentage, SearchResponse searchResult, ValueCount valueCount, OSSearchTypeHandler<Pivot> searchTypeHandler, OSGeneratedQueryContext osGeneratedQueryContext) {
        long value;
        if (valueCount == null) {
            LOG.error("Unexpected null aggregation result, returning 0 for the count. This is a bug.");
            value = 0L;
        } else {
            value = valueCount instanceof MultiBucketsAggregation.Bucket ? ((MultiBucketsAggregation.Bucket)((Object)valueCount)).getDocCount() : (valueCount instanceof Aggregations ? searchResult.getHits().getTotalHits().value : valueCount.getValue());
        }
        MultiBucketsAggregation.Bucket initialBucket = osGeneratedQueryContext.rowBucket().orElseGet(() -> InitialBucket.create(searchResult));
        Aggregation rootResult = this.extractNestedSeriesAggregation(pivot, percentage, initialBucket, osGeneratedQueryContext);
        Stream<OSPivotSeriesSpecHandler.Value> nestedSeriesResult = this.handleNestedSeriesResults(pivot, percentage, searchResult, rootResult, searchTypeHandler, osGeneratedQueryContext);
        return nestedSeriesResult.map(result -> {
            Number totalResult = (Number)result.value();
            return (double)value / totalResult.doubleValue();
        }).map(bucketPercentage -> OSPivotSeriesSpecHandler.Value.create(percentage.id(), "percentage", bucketPercentage));
    }

    private Aggregation extractNestedSeriesAggregation(Pivot pivot, Percentage percentage, HasAggregations aggregations, OSGeneratedQueryContext queryContext) {
        return switch (percentage.strategy().orElse(Percentage.Strategy.COUNT)) {
            default -> throw new MatchException(null, null);
            case Percentage.Strategy.SUM -> {
                Sum.Builder seriesSpecBuilder = Sum.builder().id(percentage.id());
                Sum seriesSpec = percentage.field().map(arg_0 -> ((Sum.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.osSumHandler.extractAggregationFromResult(pivot, (PivotSpec)seriesSpec, aggregations, queryContext);
            }
            case Percentage.Strategy.COUNT -> {
                Count.Builder seriesSpecBuilder = Count.builder().id(percentage.id());
                Count seriesSpec = percentage.field().map(arg_0 -> ((Count.Builder)seriesSpecBuilder).field(arg_0)).orElse(seriesSpecBuilder).build();
                yield this.osCountHandler.extractAggregationFromResult(pivot, (PivotSpec)seriesSpec, aggregations, queryContext);
            }
        };
    }

    @Override
    public Aggregation extractAggregationFromResult(Pivot pivot, PivotSpec spec, HasAggregations aggregations, OSGeneratedQueryContext queryContext) {
        Aggregation result = this.extractNestedSeriesAggregation(pivot, (Percentage)spec, aggregations, queryContext);
        if (result instanceof ValueCount) {
            return result;
        }
        if (result instanceof ParsedSum) {
            ParsedSum sum = (ParsedSum)result;
            return this.createValueCount(sum.getValue());
        }
        throw new IllegalStateException("Unable to parse result: " + String.valueOf(result));
    }

    private Aggregation createValueCount(final Double value) {
        return new ValueCount(){

            @Override
            public long getValue() {
                return value.longValue();
            }

            @Override
            public double value() {
                return value;
            }

            @Override
            public String getValueAsString() {
                return value.toString();
            }

            @Override
            public String getName() {
                return null;
            }

            @Override
            public String getType() {
                return null;
            }

            @Override
            public Map<String, Object> getMetadata() {
                return null;
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder xContentBuilder, ToXContent.Params params) {
                return null;
            }
        };
    }
}

