/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.index;

import java.io.IOException;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.SortedSetDocValues;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.index.TermsEnum;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;

final class SingletonSortedSetDocValues
extends SortedSetDocValues {
    private final SortedDocValues in;
    private long ord;

    public SingletonSortedSetDocValues(SortedDocValues in) {
        if (in.docID() != -1) {
            throw new IllegalStateException("iterator has already been used: docID=" + in.docID());
        }
        this.in = in;
    }

    public SortedDocValues getSortedDocValues() {
        if (this.in.docID() != -1) {
            throw new IllegalStateException("iterator has already been used: docID=" + this.in.docID());
        }
        return this.in;
    }

    @Override
    public int docID() {
        return this.in.docID();
    }

    @Override
    public long nextOrd() {
        long v = this.ord;
        this.ord = -1L;
        return v;
    }

    @Override
    public int nextDoc() throws IOException {
        int docID = this.in.nextDoc();
        if (docID != Integer.MAX_VALUE) {
            this.ord = this.in.ordValue();
        }
        return docID;
    }

    @Override
    public int advance(int target) throws IOException {
        int docID = this.in.advance(target);
        if (docID != Integer.MAX_VALUE) {
            this.ord = this.in.ordValue();
        }
        return docID;
    }

    @Override
    public boolean advanceExact(int target) throws IOException {
        if (this.in.advanceExact(target)) {
            this.ord = this.in.ordValue();
            return true;
        }
        return false;
    }

    @Override
    public BytesRef lookupOrd(long ord) throws IOException {
        return this.in.lookupOrd((int)ord);
    }

    @Override
    public long getValueCount() {
        return this.in.getValueCount();
    }

    @Override
    public long lookupTerm(BytesRef key) throws IOException {
        return this.in.lookupTerm(key);
    }

    @Override
    public TermsEnum termsEnum() throws IOException {
        return this.in.termsEnum();
    }

    @Override
    public long cost() {
        return this.in.cost();
    }
}

