/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.stream.LongStream;
import java.util.stream.StreamSupport;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisiPriorityQueue;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DisiWrapper;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.DocIdSetIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorable;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Scorer;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.TwoPhaseIterator;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.search.Weight;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.PriorityQueue;

final class MinShouldMatchSumScorer
extends Scorer {
    final int minShouldMatch;
    DisiWrapper lead;
    int doc;
    int freq;
    final DisiPriorityQueue head;
    final DisiWrapper[] tail;
    int tailSize;
    final long cost;

    static long cost(LongStream costs, int numScorers, int minShouldMatch) {
        PriorityQueue<Long> pq = new PriorityQueue<Long>(numScorers - minShouldMatch + 1){

            @Override
            protected boolean lessThan(Long a, Long b) {
                return a > b;
            }
        };
        costs.forEach(pq::insertWithOverflow);
        return StreamSupport.stream(pq.spliterator(), false).mapToLong(Number::longValue).sum();
    }

    MinShouldMatchSumScorer(Weight weight, Collection<Scorer> scorers, int minShouldMatch) {
        super(weight);
        if (minShouldMatch > scorers.size()) {
            throw new IllegalArgumentException("minShouldMatch should be <= the number of scorers");
        }
        if (minShouldMatch < 1) {
            throw new IllegalArgumentException("minShouldMatch should be >= 1");
        }
        this.minShouldMatch = minShouldMatch;
        this.doc = -1;
        this.head = new DisiPriorityQueue(scorers.size() - minShouldMatch + 1);
        this.tail = new DisiWrapper[minShouldMatch - 1];
        for (Scorer scorer : scorers) {
            this.addLead(new DisiWrapper(scorer));
        }
        this.cost = MinShouldMatchSumScorer.cost(scorers.stream().map(Scorer::iterator).mapToLong(DocIdSetIterator::cost), scorers.size(), minShouldMatch);
    }

    @Override
    public final Collection<Scorable.ChildScorable> getChildren() throws IOException {
        ArrayList<Scorable.ChildScorable> matchingChildren = new ArrayList<Scorable.ChildScorable>();
        this.updateFreq();
        DisiWrapper s = this.lead;
        while (s != null) {
            matchingChildren.add(new Scorable.ChildScorable(s.scorer, "SHOULD"));
            s = s.next;
        }
        return matchingChildren;
    }

    @Override
    public DocIdSetIterator iterator() {
        return TwoPhaseIterator.asDocIdSetIterator(this.twoPhaseIterator());
    }

    @Override
    public TwoPhaseIterator twoPhaseIterator() {
        DocIdSetIterator approximation = new DocIdSetIterator(){

            @Override
            public int docID() {
                assert (MinShouldMatchSumScorer.this.doc == MinShouldMatchSumScorer.this.lead.doc);
                return MinShouldMatchSumScorer.this.doc;
            }

            @Override
            public int nextDoc() throws IOException {
                DisiWrapper s = MinShouldMatchSumScorer.this.lead;
                while (s != null) {
                    DisiWrapper evicted = MinShouldMatchSumScorer.this.insertTailWithOverFlow(s);
                    if (evicted != null) {
                        evicted.doc = evicted.doc == MinShouldMatchSumScorer.this.doc ? evicted.iterator.nextDoc() : evicted.iterator.advance(MinShouldMatchSumScorer.this.doc + 1);
                        MinShouldMatchSumScorer.this.head.add(evicted);
                    }
                    s = s.next;
                }
                MinShouldMatchSumScorer.this.setDocAndFreq();
                return MinShouldMatchSumScorer.this.doNext();
            }

            @Override
            public int advance(int target) throws IOException {
                DisiWrapper evicted;
                DisiWrapper s = MinShouldMatchSumScorer.this.lead;
                while (s != null) {
                    evicted = MinShouldMatchSumScorer.this.insertTailWithOverFlow(s);
                    if (evicted != null) {
                        evicted.doc = evicted.iterator.advance(target);
                        MinShouldMatchSumScorer.this.head.add(evicted);
                    }
                    s = s.next;
                }
                DisiWrapper headTop = MinShouldMatchSumScorer.this.head.top();
                while (headTop.doc < target) {
                    evicted = MinShouldMatchSumScorer.this.insertTailWithOverFlow(headTop);
                    evicted.doc = evicted.iterator.advance(target);
                    headTop = MinShouldMatchSumScorer.this.head.updateTop(evicted);
                }
                MinShouldMatchSumScorer.this.setDocAndFreq();
                return MinShouldMatchSumScorer.this.doNextCandidate();
            }

            @Override
            public long cost() {
                return MinShouldMatchSumScorer.this.cost;
            }
        };
        return new TwoPhaseIterator(approximation){

            @Override
            public boolean matches() throws IOException {
                while (MinShouldMatchSumScorer.this.freq < MinShouldMatchSumScorer.this.minShouldMatch) {
                    assert (MinShouldMatchSumScorer.this.freq > 0);
                    if (MinShouldMatchSumScorer.this.freq + MinShouldMatchSumScorer.this.tailSize >= MinShouldMatchSumScorer.this.minShouldMatch) {
                        MinShouldMatchSumScorer.this.advanceTail();
                        continue;
                    }
                    return false;
                }
                return true;
            }

            @Override
            public float matchCost() {
                return MinShouldMatchSumScorer.this.tail.length;
            }
        };
    }

    private void addLead(DisiWrapper lead) {
        lead.next = this.lead;
        this.lead = lead;
        ++this.freq;
    }

    private void pushBackLeads() throws IOException {
        DisiWrapper s = this.lead;
        while (s != null) {
            this.addTail(s);
            s = s.next;
        }
    }

    private void advanceTail(DisiWrapper top) throws IOException {
        top.doc = top.iterator.advance(this.doc);
        if (top.doc == this.doc) {
            this.addLead(top);
        } else {
            this.head.add(top);
        }
    }

    private void advanceTail() throws IOException {
        DisiWrapper top = this.popTail();
        this.advanceTail(top);
    }

    private void setDocAndFreq() {
        assert (this.head.size() > 0);
        this.lead = this.head.pop();
        this.lead.next = null;
        this.freq = 1;
        this.doc = this.lead.doc;
        while (this.head.size() > 0 && this.head.top().doc == this.doc) {
            this.addLead(this.head.pop());
        }
    }

    private int doNext() throws IOException {
        while (this.freq < this.minShouldMatch) {
            assert (this.freq > 0);
            if (this.freq + this.tailSize >= this.minShouldMatch) {
                this.advanceTail();
                continue;
            }
            this.pushBackLeads();
            this.setDocAndFreq();
        }
        return this.doc;
    }

    private int doNextCandidate() throws IOException {
        while (this.freq + this.tailSize < this.minShouldMatch) {
            this.pushBackLeads();
            this.setDocAndFreq();
        }
        return this.doc;
    }

    private void updateFreq() throws IOException {
        assert (this.freq >= this.minShouldMatch);
        for (int i = this.tailSize - 1; i >= 0; --i) {
            this.advanceTail(this.tail[i]);
        }
        this.tailSize = 0;
    }

    @Override
    public float score() throws IOException {
        this.updateFreq();
        double score = 0.0;
        DisiWrapper s = this.lead;
        while (s != null) {
            score += (double)s.scorer.score();
            s = s.next;
        }
        return (float)score;
    }

    @Override
    public float getMaxScore(int upTo) throws IOException {
        return Float.POSITIVE_INFINITY;
    }

    @Override
    public int docID() {
        assert (this.doc == this.lead.doc);
        return this.doc;
    }

    private DisiWrapper insertTailWithOverFlow(DisiWrapper s) {
        if (this.tailSize < this.tail.length) {
            this.addTail(s);
            return null;
        }
        if (this.tail.length >= 1) {
            DisiWrapper top = this.tail[0];
            if (top.cost < s.cost) {
                this.tail[0] = s;
                MinShouldMatchSumScorer.downHeapCost(this.tail, this.tailSize);
                return top;
            }
        }
        return s;
    }

    private void addTail(DisiWrapper s) {
        this.tail[this.tailSize] = s;
        MinShouldMatchSumScorer.upHeapCost(this.tail, this.tailSize);
        ++this.tailSize;
    }

    private DisiWrapper popTail() {
        assert (this.tailSize > 0);
        DisiWrapper result = this.tail[0];
        this.tail[0] = this.tail[--this.tailSize];
        MinShouldMatchSumScorer.downHeapCost(this.tail, this.tailSize);
        return result;
    }

    private static void upHeapCost(DisiWrapper[] heap, int i) {
        DisiWrapper node = heap[i];
        long nodeCost = node.cost;
        int j = DisiPriorityQueue.parentNode(i);
        while (j >= 0 && nodeCost < heap[j].cost) {
            heap[i] = heap[j];
            i = j;
            j = DisiPriorityQueue.parentNode(j);
        }
        heap[i] = node;
    }

    private static void downHeapCost(DisiWrapper[] heap, int size) {
        int i = 0;
        DisiWrapper node = heap[0];
        int j = DisiPriorityQueue.leftNode(i);
        if (j < size) {
            int k = DisiPriorityQueue.rightNode(j);
            if (k < size && heap[k].cost < heap[j].cost) {
                j = k;
            }
            if (heap[j].cost < node.cost) {
                do {
                    heap[i] = heap[j];
                    i = j;
                    k = DisiPriorityQueue.rightNode(j = DisiPriorityQueue.leftNode(i));
                    if (k >= size || heap[k].cost >= heap[j].cost) continue;
                    j = k;
                } while (j < size && heap[j].cost < node.cost);
                heap[i] = node;
            }
        }
    }
}

