/*
 * Decompiled with CFR 0.152.
 */
package org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree;

import java.util.ArrayList;
import java.util.Collection;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree.Cell;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree.LegacyCell;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree.LegacyPrefixTree;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.spatial.prefix.tree.SpatialPrefixTreeFactory;
import org.graylog.shaded.elasticsearch7.org.apache.lucene.util.BytesRef;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.io.GeohashUtils;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Rectangle;
import org.locationtech.spatial4j.shape.Shape;

public class GeohashPrefixTree
extends LegacyPrefixTree {
    public GeohashPrefixTree(SpatialContext ctx, int maxLevels) {
        super(ctx, maxLevels);
        Rectangle bounds = ctx.getWorldBounds();
        if (bounds.getMinX() != -180.0) {
            throw new IllegalArgumentException("Geohash only supports lat-lon world bounds. Got " + bounds);
        }
        int MAXP = GeohashPrefixTree.getMaxLevelsPossible();
        if (maxLevels <= 0 || maxLevels > MAXP) {
            throw new IllegalArgumentException("maxLevels must be [1-" + MAXP + "] but got " + maxLevels);
        }
    }

    public static int getMaxLevelsPossible() {
        return 24;
    }

    @Override
    public Cell getWorldCell() {
        return new GhCell(BytesRef.EMPTY_BYTES, 0, 0);
    }

    @Override
    public int getLevelForDistance(double dist) {
        if (dist == 0.0) {
            return this.maxLevels;
        }
        int level = GeohashUtils.lookupHashLenForWidthHeight((double)dist, (double)dist);
        return Math.max(Math.min(level, this.maxLevels), 1);
    }

    @Override
    protected Cell getCell(Point p, int level) {
        return new GhCell(GeohashUtils.encodeLatLon((double)p.getY(), (double)p.getX(), (int)level));
    }

    private static byte[] stringToBytesPlus1(String token) {
        byte[] bytes = new byte[token.length() + 1];
        for (int i = 0; i < token.length(); ++i) {
            bytes[i] = (byte)token.charAt(i);
        }
        return bytes;
    }

    private class GhCell
    extends LegacyCell {
        private String geohash;

        GhCell(String geohash) {
            super(GeohashPrefixTree.stringToBytesPlus1(geohash), 0, geohash.length());
            this.geohash = geohash;
            if (this.isLeaf() && this.getLevel() < this.getMaxLevels()) {
                this.geohash = geohash.substring(0, geohash.length() - 1);
            }
        }

        GhCell(byte[] bytes, int off, int len) {
            super(bytes, off, len);
        }

        @Override
        protected GeohashPrefixTree getGrid() {
            return GeohashPrefixTree.this;
        }

        @Override
        protected int getMaxLevels() {
            return GeohashPrefixTree.this.maxLevels;
        }

        @Override
        protected void readCell(BytesRef bytesRef) {
            super.readCell(bytesRef);
            this.geohash = null;
        }

        @Override
        public Collection<Cell> getSubCells() {
            String[] hashes = GeohashUtils.getSubGeohashes((String)this.getGeohash());
            ArrayList<Cell> cells = new ArrayList<Cell>(hashes.length);
            for (String hash : hashes) {
                cells.add(new GhCell(hash));
            }
            return cells;
        }

        @Override
        public int getSubCellsSize() {
            return 32;
        }

        @Override
        protected GhCell getSubCell(Point p) {
            return (GhCell)this.getGrid().getCell(p, this.getLevel() + 1);
        }

        @Override
        public Shape getShape() {
            if (this.shape == null) {
                this.shape = GeohashUtils.decodeBoundary((String)this.getGeohash(), (SpatialContext)this.getGrid().getSpatialContext());
            }
            return this.shape;
        }

        private String getGeohash() {
            if (this.geohash == null) {
                this.geohash = this.getTokenBytesNoLeaf(null).utf8ToString();
            }
            return this.geohash;
        }
    }

    public static class Factory
    extends SpatialPrefixTreeFactory {
        @Override
        protected int getLevelForDistance(double degrees) {
            GeohashPrefixTree grid = new GeohashPrefixTree(this.ctx, GeohashPrefixTree.getMaxLevelsPossible());
            return grid.getLevelForDistance(degrees);
        }

        @Override
        protected SpatialPrefixTree newSPT() {
            return new GeohashPrefixTree(this.ctx, this.maxLevels != null ? this.maxLevels : GeohashPrefixTree.getMaxLevelsPossible());
        }
    }
}

